/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.iceberg.aws.AwsClientFactories;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.PropertyUtil;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkSyncClientBuilder;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.GlueClientBuilder;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.Tag;

public class AssumeRoleAwsClientFactory
implements AwsClientFactory {
    private String roleArn;
    private String externalId;
    private Set<Tag> tags;
    private int timeout;
    private String region;
    private String s3Endpoint;
    private boolean s3UseArnRegionEnabled;
    private String dynamoDbEndpoint;
    private String httpClientType;

    @Override
    public S3Client s3() {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().applyMutation(this::configure)).applyMutation(builder -> AwsClientFactories.configureEndpoint(builder, this.s3Endpoint))).serviceConfiguration(s2 -> {
            S3Configuration cfr_ignored_0 = (S3Configuration)s2.useArnRegionEnabled(Boolean.valueOf(this.s3UseArnRegionEnabled)).build();
        })).build();
    }

    @Override
    public GlueClient glue() {
        return (GlueClient)((GlueClientBuilder)GlueClient.builder().applyMutation(this::configure)).build();
    }

    @Override
    public KmsClient kms() {
        return (KmsClient)((KmsClientBuilder)KmsClient.builder().applyMutation(this::configure)).build();
    }

    @Override
    public DynamoDbClient dynamo() {
        return (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().applyMutation(this::configure)).applyMutation(builder -> AwsClientFactories.configureEndpoint(builder, this.dynamoDbEndpoint))).build();
    }

    @Override
    public void initialize(Map<String, String> properties) {
        this.roleArn = properties.get("client.assume-role.arn");
        Preconditions.checkNotNull(this.roleArn, "Cannot initialize AssumeRoleClientConfigFactory with null role ARN");
        this.timeout = PropertyUtil.propertyAsInt(properties, "client.assume-role.timeout-sec", 3600);
        this.externalId = properties.get("client.assume-role.external-id");
        this.region = properties.get("client.assume-role.region");
        Preconditions.checkNotNull(this.region, "Cannot initialize AssumeRoleClientConfigFactory with null region");
        this.s3Endpoint = properties.get("s3.endpoint");
        this.tags = AssumeRoleAwsClientFactory.toTags(properties);
        this.s3UseArnRegionEnabled = PropertyUtil.propertyAsBoolean(properties, "s3.access-points.", false);
        this.dynamoDbEndpoint = properties.get("dynamodb.endpoint");
        this.httpClientType = PropertyUtil.propertyAsString(properties, "http-client.type", "urlconnection");
    }

    protected <T extends AwsClientBuilder & AwsSyncClientBuilder> T configure(T clientBuilder) {
        AssumeRoleRequest request = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(this.roleArn).roleSessionName(this.genSessionName()).durationSeconds(Integer.valueOf(this.timeout)).externalId(this.externalId).tags(this.tags).build();
        clientBuilder.credentialsProvider((AwsCredentialsProvider)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(this.sts())).refreshRequest(request).build());
        clientBuilder.region(Region.of((String)this.region));
        ((SdkSyncClientBuilder)clientBuilder).httpClientBuilder(AwsClientFactories.configureHttpClientBuilder(this.httpClientType));
        return clientBuilder;
    }

    protected Set<Tag> tags() {
        return this.tags;
    }

    protected String region() {
        return this.region;
    }

    protected String s3Endpoint() {
        return this.s3Endpoint;
    }

    protected String httpClientType() {
        return this.httpClientType;
    }

    protected boolean s3UseArnRegionEnabled() {
        return this.s3UseArnRegionEnabled;
    }

    private StsClient sts() {
        return (StsClient)((StsClientBuilder)StsClient.builder().httpClientBuilder(AwsClientFactories.configureHttpClientBuilder(this.httpClientType))).build();
    }

    private String genSessionName() {
        return String.format("iceberg-aws-%s", UUID.randomUUID());
    }

    private static Set<Tag> toTags(Map<String, String> properties) {
        return PropertyUtil.propertiesWithPrefix(properties, "client.assume-role.tags.").entrySet().stream().map(e -> (Tag)Tag.builder().key((String)e.getKey()).value((String)e.getValue()).build()).collect(Collectors.toSet());
    }
}

