/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collection;
import java.util.List;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

public class BaseScanTaskGroup<T extends ScanTask>
implements ScanTaskGroup<T> {
    private final Object[] tasks;
    private volatile transient List<T> taskList;

    public BaseScanTaskGroup(Collection<T> tasks) {
        Preconditions.checkNotNull(tasks, "tasks cannot be null");
        this.tasks = tasks.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> tasks() {
        if (this.taskList == null) {
            BaseScanTaskGroup baseScanTaskGroup = this;
            synchronized (baseScanTaskGroup) {
                if (this.taskList == null) {
                    ImmutableList.Builder listBuilder = ImmutableList.builderWithExpectedSize(this.tasks.length);
                    for (Object task : this.tasks) {
                        listBuilder.add((ScanTask)task);
                    }
                    this.taskList = listBuilder.build();
                }
            }
        }
        return this.taskList;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("tasks", Joiner.on(", ").join(this.tasks)).toString();
    }
}

