/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.model.GenericMetadata;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GenericMetadata", generator="Immutables")
@Immutable
public final class ImmutableGenericMetadata
implements GenericMetadata {
    private final String variant;
    private final JsonNode metadata;

    private ImmutableGenericMetadata(String variant, JsonNode metadata) {
        this.variant = variant;
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="variant")
    public String getVariant() {
        return this.variant;
    }

    @Override
    @JsonProperty(value="metadata")
    public JsonNode getMetadata() {
        return this.metadata;
    }

    public final ImmutableGenericMetadata withVariant(String value) {
        String newValue = Objects.requireNonNull(value, "variant");
        if (this.variant.equals(newValue)) {
            return this;
        }
        return new ImmutableGenericMetadata(newValue, this.metadata);
    }

    public final ImmutableGenericMetadata withMetadata(JsonNode value) {
        if (this.metadata == value) {
            return this;
        }
        JsonNode newValue = Objects.requireNonNull(value, "metadata");
        return new ImmutableGenericMetadata(this.variant, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGenericMetadata && this.equalTo(0, (ImmutableGenericMetadata)another);
    }

    private boolean equalTo(int synthetic, ImmutableGenericMetadata another) {
        return this.variant.equals(another.variant) && this.metadata.equals(another.metadata);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.variant.hashCode();
        h2 += (h2 << 5) + this.metadata.hashCode();
        return h2;
    }

    public String toString() {
        return "GenericMetadata{variant=" + this.variant + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGenericMetadata fromJson(Json json) {
        Builder builder = ImmutableGenericMetadata.builder();
        if (json.variant != null) {
            builder.variant(json.variant);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    public static ImmutableGenericMetadata copyOf(GenericMetadata instance) {
        if (instance instanceof ImmutableGenericMetadata) {
            return (ImmutableGenericMetadata)instance;
        }
        return ImmutableGenericMetadata.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GenericMetadata", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VARIANT = 1L;
        private static final long INIT_BIT_METADATA = 2L;
        private long initBits = 3L;
        @Nullable
        private String variant;
        @Nullable
        private JsonNode metadata;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GenericMetadata instance) {
            Objects.requireNonNull(instance, "instance");
            this.variant(instance.getVariant());
            this.metadata(instance.getMetadata());
            return this;
        }

        @JsonProperty(value="variant")
        @CanIgnoreReturnValue
        public final Builder variant(String variant) {
            this.variant = Objects.requireNonNull(variant, "variant");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="metadata")
        @CanIgnoreReturnValue
        public final Builder metadata(JsonNode metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGenericMetadata build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGenericMetadata(this.variant, this.metadata);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("variant");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("metadata");
            }
            return "Cannot build GenericMetadata, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GenericMetadata", generator="Immutables")
    static final class Json
    implements GenericMetadata {
        @Nullable
        String variant;
        @Nullable
        JsonNode metadata;

        Json() {
        }

        @JsonProperty(value="variant")
        public void setVariant(String variant) {
            this.variant = variant;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(JsonNode metadata) {
            this.metadata = metadata;
        }

        @Override
        public String getVariant() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JsonNode getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

