/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectReader;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;
import org.projectnessie.client.rest.NessieInternalServerException;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.client.rest.NessieServiceException;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.error.NessieError;

public class ResponseCheckFilter {
    public static void checkResponse(ResponseContext con, ObjectMapper mapper) throws Exception {
        NessieServiceException exception;
        NessieError error;
        Status status = con.getResponseCode();
        if (status.getCode() > 199 && status.getCode() < 300) {
            return;
        }
        try (InputStream is = con.getErrorStream();){
            error = ResponseCheckFilter.decodeErrorObject(status, is, mapper.reader());
        }
        Optional<Exception> modelException = ErrorCode.asException(error);
        if (modelException.isPresent()) {
            throw modelException.get();
        }
        switch (status) {
            case INTERNAL_SERVER_ERROR: {
                exception = new NessieInternalServerException(error);
                break;
            }
            case UNAUTHORIZED: {
                exception = new NessieNotAuthorizedException(error);
                break;
            }
            default: {
                exception = new NessieServiceException(error);
            }
        }
        if (error.getClientProcessingException() != null) {
            exception.addSuppressed(error.getClientProcessingException());
        }
        throw exception;
    }

    private static NessieError decodeErrorObject(Status status, InputStream inputStream, ObjectReader reader) {
        NessieError error;
        if (inputStream == null) {
            error = ImmutableNessieError.builder().errorCode(ErrorCode.UNKNOWN).status(status.getCode()).reason(status.getReason()).message("Could not parse error object in response.").clientProcessingException(new RuntimeException("Could not parse error object in response.")).build();
        } else {
            try {
                JsonNode errorData = reader.readTree(inputStream);
                try {
                    error = reader.treeToValue(errorData, NessieError.class);
                }
                catch (JsonProcessingException e) {
                    error = ImmutableNessieError.builder().message(errorData.toString()).status(status.getCode()).reason(status.getReason()).clientProcessingException(e).build();
                }
            }
            catch (IOException e) {
                error = ImmutableNessieError.builder().status(status.getCode()).reason(status.getReason()).clientProcessingException(e).build();
            }
        }
        return error;
    }
}

