/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.transforms.SortOrderVisitor;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.util.CopySortOrderFields;
import org.apache.iceberg.util.Pair;

public class SortOrderUtil {
    private SortOrderUtil() {
    }

    public static SortOrder buildSortOrder(Table table) {
        return SortOrderUtil.buildSortOrder(table.schema(), table.spec(), table.sortOrder());
    }

    public static SortOrder buildSortOrder(Table table, SortOrder sortOrder) {
        return SortOrderUtil.buildSortOrder(table.schema(), table.spec(), sortOrder);
    }

    public static SortOrder buildSortOrder(Schema schema, PartitionSpec spec, SortOrder sortOrder) {
        if (sortOrder.isUnsorted() && spec.isUnpartitioned()) {
            return SortOrder.unsorted();
        }
        Map<Pair<Transform<?, ?>, Integer>, PartitionField> requiredClusteringFields = SortOrderUtil.requiredClusteringFields(spec);
        for (SortField sortField : sortOrder.fields()) {
            Pair sourceAndTransform = Pair.of(sortField.transform(), sortField.sourceId());
            if (requiredClusteringFields.containsKey(sourceAndTransform)) {
                requiredClusteringFields.remove(sourceAndTransform);
                continue;
            }
            for (PartitionField field : spec.fields()) {
                if (sortField.sourceId() != field.sourceId() || !sortField.transform().satisfiesOrderOf(field.transform())) continue;
                requiredClusteringFields.remove(Pair.of(field.transform(), field.sourceId()));
            }
        }
        SortOrder.Builder builder = SortOrder.builderFor(schema);
        for (PartitionField field : requiredClusteringFields.values()) {
            String sourceName = schema.findColumnName(field.sourceId());
            builder.asc(Expressions.transform(sourceName, field.transform()));
        }
        SortOrderVisitor.visit(sortOrder, new CopySortOrderFields(builder));
        return builder.build();
    }

    private static Map<Pair<Transform<?, ?>, Integer>, PartitionField> requiredClusteringFields(PartitionSpec spec) {
        LinkedHashMap<Pair<Transform<?, ?>, Integer>, PartitionField> requiredClusteringFields = Maps.newLinkedHashMap();
        for (PartitionField partField : spec.fields()) {
            if (partField.transform().toString().equals("void")) continue;
            requiredClusteringFields.put(Pair.of(partField.transform(), partField.sourceId()), partField);
        }
        for (PartitionField partField : spec.fields()) {
            for (PartitionField field : spec.fields()) {
                if (partField.equals(field) || partField.sourceId() != field.sourceId() || !partField.transform().satisfiesOrderOf(field.transform())) continue;
                requiredClusteringFields.remove(Pair.of(field.transform(), field.sourceId()));
            }
        }
        return requiredClusteringFields;
    }

    public static Set<String> orderPreservingSortedColumns(SortOrder sortOrder) {
        if (sortOrder == null) {
            return Collections.emptySet();
        }
        return sortOrder.fields().stream().filter(f -> f.transform().preservesOrder()).map(SortField::sourceId).map(sid -> sortOrder.schema().findColumnName((int)sid)).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

