/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.iceberg.LocationProviders;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.rest.ErrorHandlers;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;

class RESTTableOperations
implements TableOperations {
    private static final String METADATA_FOLDER_NAME = "metadata";
    private final RESTClient client;
    private final String path;
    private final Supplier<Map<String, String>> headers;
    private final FileIO io;
    private final List<MetadataUpdate> createChanges;
    private final TableMetadata replaceBase;
    private UpdateType updateType;
    private TableMetadata current;

    RESTTableOperations(RESTClient client, String path, Supplier<Map<String, String>> headers, FileIO io, TableMetadata current) {
        this(client, path, headers, io, UpdateType.SIMPLE, Lists.newArrayList(), current);
    }

    RESTTableOperations(RESTClient client, String path, Supplier<Map<String, String>> headers, FileIO io, UpdateType updateType, List<MetadataUpdate> createChanges, TableMetadata current) {
        this.client = client;
        this.path = path;
        this.headers = headers;
        this.io = io;
        this.updateType = updateType;
        this.createChanges = createChanges;
        this.replaceBase = current;
        this.current = updateType == UpdateType.CREATE ? null : current;
    }

    @Override
    public TableMetadata current() {
        return this.current;
    }

    @Override
    public TableMetadata refresh() {
        return this.updateCurrentMetadata(this.client.get(this.path, LoadTableResponse.class, this.headers, ErrorHandlers.tableErrorHandler()));
    }

    @Override
    public void commit(TableMetadata base, TableMetadata metadata) {
        Consumer<ErrorResponse> errorHandler;
        List<Object> baseChanges;
        UpdateTableRequest.Builder requestBuilder;
        switch (this.updateType) {
            case CREATE: {
                Preconditions.checkState(base == null, "Invalid base metadata for create transaction, expected null: %s", (Object)base);
                requestBuilder = UpdateTableRequest.builderForCreate();
                baseChanges = this.createChanges;
                errorHandler = ErrorHandlers.tableErrorHandler();
                break;
            }
            case REPLACE: {
                Preconditions.checkState(base != null, "Invalid base metadata: null");
                requestBuilder = UpdateTableRequest.builderForReplace(this.replaceBase);
                baseChanges = this.createChanges;
                errorHandler = ErrorHandlers.tableCommitHandler();
                break;
            }
            case SIMPLE: {
                Preconditions.checkState(base != null, "Invalid base metadata: null");
                requestBuilder = UpdateTableRequest.builderFor(base);
                baseChanges = ImmutableList.of();
                errorHandler = ErrorHandlers.tableCommitHandler();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Update type %s is not supported", new Object[]{this.updateType}));
            }
        }
        baseChanges.forEach(requestBuilder::update);
        metadata.changes().forEach(requestBuilder::update);
        UpdateTableRequest request = requestBuilder.build();
        LoadTableResponse response = this.client.post(this.path, (RESTRequest)request, LoadTableResponse.class, this.headers, errorHandler);
        this.updateType = UpdateType.SIMPLE;
        this.updateCurrentMetadata(response);
    }

    @Override
    public FileIO io() {
        return this.io;
    }

    private TableMetadata updateCurrentMetadata(LoadTableResponse response) {
        if (this.current == null || !Objects.equals(this.current.metadataFileLocation(), response.metadataLocation())) {
            this.current = response.tableMetadata();
        }
        return this.current;
    }

    private static String metadataFileLocation(TableMetadata metadata, String filename) {
        String metadataLocation = metadata.properties().get("write.metadata.path");
        if (metadataLocation != null) {
            return String.format("%s/%s", metadataLocation, filename);
        }
        return String.format("%s/%s/%s", metadata.location(), METADATA_FOLDER_NAME, filename);
    }

    @Override
    public String metadataFileLocation(String filename) {
        return RESTTableOperations.metadataFileLocation(this.current(), filename);
    }

    @Override
    public LocationProvider locationProvider() {
        return LocationProviders.locationsFor(this.current().location(), this.current().properties());
    }

    @Override
    public TableOperations temp(final TableMetadata uncommittedMetadata) {
        return new TableOperations(){

            @Override
            public TableMetadata current() {
                return uncommittedMetadata;
            }

            @Override
            public TableMetadata refresh() {
                throw new UnsupportedOperationException("Cannot call refresh on temporary table operations");
            }

            @Override
            public void commit(TableMetadata base, TableMetadata metadata) {
                throw new UnsupportedOperationException("Cannot call commit on temporary table operations");
            }

            @Override
            public String metadataFileLocation(String fileName) {
                return RESTTableOperations.metadataFileLocation(uncommittedMetadata, fileName);
            }

            @Override
            public LocationProvider locationProvider() {
                return LocationProviders.locationsFor(uncommittedMetadata.location(), uncommittedMetadata.properties());
            }

            @Override
            public FileIO io() {
                return RESTTableOperations.this.io();
            }

            @Override
            public EncryptionManager encryption() {
                return RESTTableOperations.this.encryption();
            }

            @Override
            public long newSnapshotId() {
                return RESTTableOperations.this.newSnapshotId();
            }
        };
    }

    static enum UpdateType {
        CREATE,
        REPLACE,
        SIMPLE;

    }
}

