/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.PendingUpdate;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.Tasks;

class SetSnapshotOperation
implements PendingUpdate<Snapshot> {
    private final TableOperations ops;
    private TableMetadata base;
    private Long targetSnapshotId = null;
    private boolean isRollback = false;

    SetSnapshotOperation(TableOperations ops) {
        this.ops = ops;
        this.base = ops.current();
    }

    public SetSnapshotOperation setCurrentSnapshot(long snapshotId) {
        ValidationException.check(this.base.snapshot(snapshotId) != null, "Cannot roll back to unknown snapshot id: %s", snapshotId);
        this.targetSnapshotId = snapshotId;
        return this;
    }

    public SetSnapshotOperation rollbackToTime(long timestampMillis) {
        Snapshot snapshot = SetSnapshotOperation.findLatestAncestorOlderThan(this.base, timestampMillis);
        Preconditions.checkArgument(snapshot != null, "Cannot roll back, no valid snapshot older than: %s", timestampMillis);
        this.targetSnapshotId = snapshot.snapshotId();
        this.isRollback = true;
        return this;
    }

    public SetSnapshotOperation rollbackTo(long snapshotId) {
        TableMetadata current = this.base;
        ValidationException.check(current.snapshot(snapshotId) != null, "Cannot roll back to unknown snapshot id: %s", snapshotId);
        ValidationException.check(SetSnapshotOperation.isCurrentAncestor(current, snapshotId), "Cannot roll back to snapshot, not an ancestor of the current state: %s", snapshotId);
        return this.setCurrentSnapshot(snapshotId);
    }

    @Override
    public Snapshot apply() {
        this.base = this.ops.refresh();
        if (this.targetSnapshotId == null) {
            return this.base.currentSnapshot();
        }
        ValidationException.check(!this.isRollback || SetSnapshotOperation.isCurrentAncestor(this.base, this.targetSnapshotId), "Cannot roll back to %s: not an ancestor of the current table state", this.targetSnapshotId);
        return this.base.snapshot(this.targetSnapshotId);
    }

    @Override
    public void commit() {
        Tasks.foreach(this.ops).retry(this.base.propertyAsInt("commit.retry.num-retries", 4)).exponentialBackoff(this.base.propertyAsInt("commit.retry.min-wait-ms", 100), this.base.propertyAsInt("commit.retry.max-wait-ms", 60000), this.base.propertyAsInt("commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(taskOps -> {
            Snapshot snapshot = this.apply();
            TableMetadata updated = TableMetadata.buildFrom(this.base).setBranchSnapshot(snapshot.snapshotId(), "main").build();
            if (updated.changes().isEmpty()) {
                return;
            }
            taskOps.commit(this.base, updated.withUUID());
        });
    }

    private static Snapshot findLatestAncestorOlderThan(TableMetadata meta, long timestampMillis) {
        long snapshotTimestamp = 0L;
        Snapshot result = null;
        for (Long snapshotId : SetSnapshotOperation.currentAncestors(meta)) {
            Snapshot snapshot = meta.snapshot(snapshotId);
            if (snapshot.timestampMillis() >= timestampMillis || snapshot.timestampMillis() <= snapshotTimestamp) continue;
            result = snapshot;
            snapshotTimestamp = snapshot.timestampMillis();
        }
        return result;
    }

    private static List<Long> currentAncestors(TableMetadata meta) {
        return SnapshotUtil.ancestorIds(meta.currentSnapshot(), meta::snapshot);
    }

    private static boolean isCurrentAncestor(TableMetadata meta, long snapshotId) {
        return SetSnapshotOperation.currentAncestors(meta).contains(snapshotId);
    }
}

