/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iceberg.BaseScan;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataTableScan;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.IncrementalAppendScan;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.events.IncrementalScanEvent;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.TableScanUtil;

class BaseIncrementalAppendScan
extends BaseScan<IncrementalAppendScan, FileScanTask, CombinedScanTask>
implements IncrementalAppendScan {
    BaseIncrementalAppendScan(TableOperations ops, Table table) {
        this(ops, table, table.schema(), new TableScanContext());
    }

    BaseIncrementalAppendScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        super(ops, table, schema, context);
    }

    @Override
    protected IncrementalAppendScan newRefinedScan(TableOperations newOps, Table newTable, Schema newSchema, TableScanContext newContext) {
        return new BaseIncrementalAppendScan(newOps, newTable, newSchema, newContext);
    }

    @Override
    public IncrementalAppendScan fromSnapshotInclusive(long fromSnapshotId) {
        Preconditions.checkArgument(this.table().snapshot(fromSnapshotId) != null, "Cannot find the starting snapshot: %s", fromSnapshotId);
        return this.newRefinedScan(this.tableOps(), this.table(), this.schema(), this.context().fromSnapshotIdInclusive(fromSnapshotId));
    }

    @Override
    public IncrementalAppendScan fromSnapshotExclusive(long fromSnapshotId) {
        return this.newRefinedScan(this.tableOps(), this.table(), this.schema(), this.context().fromSnapshotIdExclusive(fromSnapshotId));
    }

    @Override
    public IncrementalAppendScan toSnapshot(long toSnapshotId) {
        Preconditions.checkArgument(this.table().snapshot(toSnapshotId) != null, "Cannot find end snapshot: %s", toSnapshotId);
        return this.newRefinedScan(this.tableOps(), this.table(), this.schema(), this.context().toSnapshotId(toSnapshotId));
    }

    @Override
    public CloseableIterable<FileScanTask> planFiles() {
        Long fromSnapshotId = this.context().fromSnapshotId();
        Long toSnapshotId = this.context().toSnapshotId();
        if (fromSnapshotId == null && toSnapshotId == null && this.table().currentSnapshot() == null) {
            return CloseableIterable.empty();
        }
        long toSnapshotIdInclusive = this.toSnapshotIdInclusive();
        Long fromSnapshotIdExclusive = this.fromSnapshotIdExclusive(fromSnapshotId, toSnapshotIdInclusive);
        if (fromSnapshotIdExclusive != null) {
            Listeners.notifyAll(new IncrementalScanEvent(this.table().name(), fromSnapshotIdExclusive, toSnapshotIdInclusive, this.context().rowFilter(), this.table().schema(), false));
        } else {
            Snapshot oldestAncestorSnapshot = SnapshotUtil.oldestAncestorOf(toSnapshotIdInclusive, this.table()::snapshot);
            Listeners.notifyAll(new IncrementalScanEvent(this.table().name(), oldestAncestorSnapshot.snapshotId(), toSnapshotIdInclusive, this.context().rowFilter(), this.table().schema(), true));
        }
        List<Snapshot> snapshots = BaseIncrementalAppendScan.appendsBetween(this.table(), fromSnapshotIdExclusive, toSnapshotIdInclusive);
        if (snapshots.isEmpty()) {
            return CloseableIterable.empty();
        }
        return this.appendFilesFromSnapshots(snapshots);
    }

    @Override
    public CloseableIterable<CombinedScanTask> planTasks() {
        CloseableIterable<FileScanTask> fileScanTasks = this.planFiles();
        CloseableIterable<FileScanTask> splitFiles = TableScanUtil.splitFiles(fileScanTasks, this.targetSplitSize());
        return TableScanUtil.planTasks(splitFiles, this.targetSplitSize(), this.splitLookback(), this.splitOpenFileCost());
    }

    private Long fromSnapshotIdExclusive(Long fromSnapshotId, long toSnapshotIdInclusive) {
        if (fromSnapshotId != null) {
            if (this.context().fromSnapshotInclusive()) {
                Preconditions.checkArgument(SnapshotUtil.isAncestorOf(this.table(), toSnapshotIdInclusive, fromSnapshotId), "Starting snapshot (inclusive) %s is not an ancestor of end snapshot %s", (Object)fromSnapshotId, toSnapshotIdInclusive);
                return this.table().snapshot(fromSnapshotId).parentId();
            }
            Preconditions.checkArgument(SnapshotUtil.isParentAncestorOf(this.table(), toSnapshotIdInclusive, fromSnapshotId), "Starting snapshot (exclusive) %s is not a parent ancestor of end snapshot %s", (Object)fromSnapshotId, toSnapshotIdInclusive);
            return fromSnapshotId;
        }
        return null;
    }

    private long toSnapshotIdInclusive() {
        if (this.context().toSnapshotId() != null) {
            return this.context().toSnapshotId();
        }
        Snapshot currentSnapshot = this.table().currentSnapshot();
        Preconditions.checkArgument(currentSnapshot != null, "Invalid config: end snapshot is not set and table has no current snapshot");
        return currentSnapshot.snapshotId();
    }

    private CloseableIterable<FileScanTask> appendFilesFromSnapshots(List<Snapshot> snapshots) {
        HashSet snapshotIds = Sets.newHashSet(Iterables.transform(snapshots, Snapshot::snapshotId));
        ImmutableSet<ManifestFile> manifests = FluentIterable.from(snapshots).transformAndConcat(Snapshot::dataManifests).filter(manifestFile -> snapshotIds.contains(manifestFile.snapshotId())).toSet();
        ManifestGroup manifestGroup = new ManifestGroup(this.tableOps().io(), manifests).caseSensitive(this.context().caseSensitive()).select(this.context().returnColumnStats() ? DataTableScan.SCAN_WITH_STATS_COLUMNS : DataTableScan.SCAN_COLUMNS).filterData(this.context().rowFilter()).filterManifestEntries(manifestEntry -> snapshotIds.contains(manifestEntry.snapshotId()) && manifestEntry.status() == ManifestEntry.Status.ADDED).specsById(this.tableOps().current().specsById()).ignoreDeleted();
        if (this.context().ignoreResiduals()) {
            manifestGroup = manifestGroup.ignoreResiduals();
        }
        if (manifests.size() > 1 && (DataTableScan.PLAN_SCANS_WITH_WORKER_POOL || this.context().planWithCustomizedExecutor())) {
            manifestGroup = manifestGroup.planWith(this.context().planExecutor());
        }
        return manifestGroup.planFiles();
    }

    private static List<Snapshot> appendsBetween(Table table, Long fromSnapshotIdExclusive, long toSnapshotIdInclusive) {
        ArrayList<Snapshot> snapshots = Lists.newArrayList();
        for (Snapshot snapshot : SnapshotUtil.ancestorsBetween(toSnapshotIdInclusive, fromSnapshotIdExclusive, table::snapshot)) {
            if (!snapshot.operation().equals("append")) continue;
            snapshots.add(snapshot);
        }
        return snapshots;
    }
}

