/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableCommitMeta;

@Schema(type=SchemaType.OBJECT, title="CommitMeta", properties={@SchemaProperty(name="hash", pattern="^[0-9a-fA-F]{16,64}$")})
@JsonSerialize(as=ImmutableCommitMeta.class)
@JsonDeserialize(as=ImmutableCommitMeta.class)
@Value.Immutable
public abstract class CommitMeta {
    @Nullable
    public abstract String getHash();

    @Nullable
    public abstract String getCommitter();

    @Nullable
    public abstract String getAuthor();

    @Nullable
    public abstract String getSignedOffBy();

    @NotBlank
    public abstract String getMessage();

    @Nullable
    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    public abstract Instant getCommitTime();

    @Nullable
    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    public abstract Instant getAuthorTime();

    @NotNull
    public abstract Map<String, String> getProperties();

    public ImmutableCommitMeta.Builder toBuilder() {
        return ImmutableCommitMeta.builder().from(this);
    }

    public static ImmutableCommitMeta.Builder builder() {
        return ImmutableCommitMeta.builder();
    }

    public static CommitMeta fromMessage(String message) {
        return ImmutableCommitMeta.builder().message(message).build();
    }

    public static class InstantDeserializer
    extends StdDeserializer<Instant> {
        public InstantDeserializer() {
            this((Class<?>)null);
        }

        protected InstantDeserializer(Class<?> vc) {
            super(vc);
        }

        @Override
        public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return Instant.parse(p.getText());
        }
    }

    public static class InstantSerializer
    extends StdSerializer<Instant> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_INSTANT;

        public InstantSerializer() {
            this(Instant.class);
        }

        protected InstantSerializer(Class<Instant> t) {
            super(t);
        }

        @Override
        public void serialize(Instant value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(FORMATTER.format(value));
        }
    }
}

