/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.vector;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcInputFormat;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mr.hive.vector.VectorizedRowBatchIterator;
import org.apache.iceberg.mr.mapred.MapredIcebergInputFormat;
import org.apache.iceberg.orc.VectorizedReadUtils;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.iceberg.shaded.org.apache.orc.impl.OrcTail;

public class HiveVectorizedReader {
    private HiveVectorizedReader() {
    }

    public static <D> CloseableIterable<D> reader(InputFile inputFile, FileScanTask task, Map<Integer, ?> idToConstant, TaskAttemptContext context) {
        JobConf job = (JobConf)context.getConfiguration();
        Path path = new Path(inputFile.location());
        FileFormat format = task.file().format();
        Reporter reporter = ((MapredIcebergInputFormat.CompatibilityTaskAttemptContextImpl)context).getLegacyReporter();
        int[] partitionColIndices = null;
        Object[] partitionValues = null;
        PartitionSpec partitionSpec = task.spec();
        if (!partitionSpec.isUnpartitioned()) {
            List readColumnIds = ColumnProjectionUtils.getReadColumnIDs((Configuration)job);
            List<PartitionField> fields = partitionSpec.fields();
            LinkedList<Integer> partitionColIndicesList = Lists.newLinkedList();
            LinkedList<?> partitionValuesList = Lists.newLinkedList();
            for (PartitionField field : fields) {
                if (!field.transform().isIdentity()) continue;
                int hiveColIndex = field.sourceId() - 1;
                readColumnIds.remove((Object)hiveColIndex);
                partitionColIndicesList.add(hiveColIndex);
                partitionValuesList.add(idToConstant.get(field.sourceId()));
            }
            partitionColIndices = ArrayUtils.toPrimitive((Integer[])partitionColIndicesList.toArray(new Integer[0]));
            partitionValues = partitionValuesList.toArray(new Object[0]);
            ColumnProjectionUtils.setReadColumns((Configuration)job, (List)readColumnIds);
        }
        try {
            switch (format) {
                case ORC: {
                    OrcTail orcTail = VectorizedReadUtils.getOrcTail(inputFile, job);
                    OrcSplit split = new OrcSplit(path, null, task.start(), task.length(), null, orcTail, false, false, Lists.newArrayList(), 0L, task.length(), path.getParent());
                    RecordReader recordReader = new VectorizedOrcInputFormat().getRecordReader((InputSplit)split, job, reporter);
                    return HiveVectorizedReader.createVectorizedRowBatchIterable((RecordReader<NullWritable, VectorizedRowBatch>)recordReader, job, partitionColIndices, partitionValues);
                }
            }
            throw new UnsupportedOperationException("Vectorized Hive reading unimplemented for format: " + (Object)((Object)format));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error creating vectorized record reader for " + inputFile, ioe);
        }
    }

    private static <D> CloseableIterable<D> createVectorizedRowBatchIterable(RecordReader<NullWritable, VectorizedRowBatch> hiveRecordReader, JobConf job, int[] partitionColIndices, Object[] partitionValues) {
        final VectorizedRowBatchIterator iterator = new VectorizedRowBatchIterator(hiveRecordReader, job, partitionColIndices, partitionValues);
        return new CloseableIterable<D>(){

            @Override
            public CloseableIterator iterator() {
                return iterator;
            }

            @Override
            public void close() throws IOException {
                iterator.close();
            }
        };
    }
}

