/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.HadoopConfigurable;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.InputFormatConfig;
import org.apache.iceberg.mr.hive.HiveIcebergInputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergMetaHook;
import org.apache.iceberg.mr.hive.HiveIcebergOutputCommitter;
import org.apache.iceberg.mr.hive.HiveIcebergOutputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergSerDe;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.SerializationUtil;

public class HiveIcebergStorageHandler
implements HiveStoragePredicateHandler,
HiveStorageHandler {
    private static final Splitter TABLE_NAME_SPLITTER = Splitter.on("..");
    private static final String TABLE_NAME_SEPARATOR = "..";
    static final String WRITE_KEY = "HiveIcebergStorageHandler_write";
    private Configuration conf;

    public Class<? extends InputFormat> getInputFormatClass() {
        return HiveIcebergInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HiveIcebergOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return HiveIcebergSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return new HiveIcebergMetaHook(this.conf);
    }

    public HiveAuthorizationProvider getAuthorizationProvider() {
        return null;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> map) {
        HiveIcebergStorageHandler.overlayTableProperties(this.conf, tableDesc, map);
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> map) {
        HiveIcebergStorageHandler.overlayTableProperties(this.conf, tableDesc, map);
        map.put("mapred.output.committer.class", HiveIcebergOutputCommitter.class.getName());
        map.put(WRITE_KEY, "true");
        tableDesc.getProperties().put(WRITE_KEY, "true");
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> map) {
    }

    public void configureInputJobCredentials(TableDesc tableDesc, Map<String, String> secrets) {
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        if (tableDesc != null && tableDesc.getProperties() != null && tableDesc.getProperties().get(WRITE_KEY) != null) {
            String tableName = tableDesc.getTableName();
            Preconditions.checkArgument(!tableName.contains(TABLE_NAME_SEPARATOR), "Can not handle table " + tableName + ". Its name contains '" + TABLE_NAME_SEPARATOR + "'");
            String tables = jobConf.get("iceberg.mr.output.tables");
            tables = tables == null ? tableName : tables + TABLE_NAME_SEPARATOR + tableName;
            jobConf.set("mapred.output.committer.class", HiveIcebergOutputCommitter.class.getName());
            jobConf.set("iceberg.mr.output.tables", tables);
            String catalogName = tableDesc.getProperties().getProperty("iceberg.catalog");
            if (catalogName != null) {
                jobConf.set("iceberg.mr.table.catalog." + tableName, catalogName);
            }
        }
        if (HiveConf.getBoolVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED)) {
            jobConf.setEnum("iceberg.mr.in.memory.data.model", (Enum)InputFormatConfig.InMemoryDataModel.HIVE);
            this.conf.setBoolean("skip.residual.filtering", true);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, Deserializer deserializer, ExprNodeDesc exprNodeDesc) {
        HiveStoragePredicateHandler.DecomposedPredicate predicate = new HiveStoragePredicateHandler.DecomposedPredicate();
        predicate.residualPredicate = (ExprNodeGenericFuncDesc)exprNodeDesc;
        predicate.pushedPredicate = (ExprNodeGenericFuncDesc)exprNodeDesc;
        return predicate;
    }

    public static Table table(Configuration config, String name) {
        Table table = (Table)SerializationUtil.deserializeFromBase64(config.get("iceberg.mr.serialized.table." + name));
        HiveIcebergStorageHandler.checkAndSetIoConfig(config, table);
        return table;
    }

    public static void checkAndSetIoConfig(Configuration config, Table table) {
        if (table != null && config.getBoolean("iceberg.mr.config.serialization.disabled", false) && table.io() instanceof HadoopConfigurable) {
            ((HadoopConfigurable)((Object)table.io())).setConf(config);
        }
    }

    public static void checkAndSkipIoConfigSerialization(Configuration config, Table table) {
        if (table != null && config.getBoolean("iceberg.mr.config.serialization.disabled", false) && table.io() instanceof HadoopConfigurable) {
            ((HadoopConfigurable)((Object)table.io())).serializeConfWith(conf -> new NonSerializingConfig(config)::get);
        }
    }

    public static Collection<String> outputTables(Configuration config) {
        return TABLE_NAME_SPLITTER.splitToList(config.get("iceberg.mr.output.tables"));
    }

    public static String catalogName(Configuration config, String name) {
        return config.get("iceberg.mr.table.catalog." + name);
    }

    public static Schema schema(Configuration config) {
        return SchemaParser.fromJson(config.get("iceberg.mr.table.schema"));
    }

    @VisibleForTesting
    static void overlayTableProperties(Configuration configuration, TableDesc tableDesc, Map<String, String> map) {
        Properties props = tableDesc.getProperties();
        Table table = Catalogs.loadTable(configuration, props);
        String schemaJson = SchemaParser.toJson(table.schema());
        Maps.fromProperties(props).entrySet().stream().filter(entry -> !map.containsKey(entry.getKey())).forEach(entry -> map.put((String)entry.getKey(), (String)entry.getValue()));
        map.put("iceberg.mr.table.identifier", props.getProperty("name"));
        map.put("iceberg.mr.table.location", table.location());
        map.put("iceberg.mr.table.schema", schemaJson);
        Table serializableTable = SerializableTable.copyOf(table);
        HiveIcebergStorageHandler.checkAndSkipIoConfigSerialization(configuration, serializableTable);
        map.put("iceberg.mr.serialized.table." + tableDesc.getTableName(), SerializationUtil.serializeToBase64(serializableTable));
        map.remove("columns.comments");
        props.put("iceberg.mr.table.schema", schemaJson);
    }

    private static class NonSerializingConfig
    implements Serializable {
        private final transient Configuration conf;

        NonSerializingConfig(Configuration conf) {
            this.conf = conf;
        }

        public Configuration get() {
            if (this.conf == null) {
                throw new IllegalStateException("Configuration was not serialized on purpose but was not set manually either");
            }
            return this.conf;
        }
    }
}

