/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.io.Serializable;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.PropertyUtil;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;

public class AwsProperties
implements Serializable {
    public static final String S3FILEIO_SSE_TYPE = "s3.sse.type";
    public static final String S3FILEIO_SSE_TYPE_NONE = "none";
    public static final String S3FILEIO_SSE_TYPE_KMS = "kms";
    public static final String S3FILEIO_SSE_TYPE_S3 = "s3";
    public static final String S3FILEIO_SSE_TYPE_CUSTOM = "custom";
    public static final String S3FILEIO_SSE_KEY = "s3.sse.key";
    public static final String S3FILEIO_SSE_MD5 = "s3.sse.md5";
    public static final String GLUE_CATALOG_ID = "glue.id";
    public static final String GLUE_CATALOG_SKIP_ARCHIVE = "glue.skip-archive";
    public static final boolean GLUE_CATALOG_SKIP_ARCHIVE_DEFAULT = false;
    public static final String S3FILEIO_MULTIPART_UPLOAD_THREADS = "s3.multipart.num-threads";
    public static final String S3FILEIO_MULTIPART_SIZE = "s3.multipart.part-size-bytes";
    public static final int S3FILEIO_MULTIPART_SIZE_DEFAULT = 0x2000000;
    public static final int S3FILEIO_MULTIPART_SIZE_MIN = 0x500000;
    public static final String S3FILEIO_MULTIPART_THRESHOLD_FACTOR = "s3.multipart.threshold";
    public static final double S3FILEIO_MULTIPART_THRESHOLD_FACTOR_DEFAULT = 1.5;
    public static final String S3FILEIO_STAGING_DIRECTORY = "s3.staging-dir";
    public static final String S3FILEIO_ACL = "s3.acl";
    public static final String S3FILEIO_ENDPOINT = "s3.endpoint";
    public static final String S3FILEIO_ACCESS_KEY_ID = "s3.access-key-id";
    public static final String S3FILEIO_SECRET_ACCESS_KEY = "s3.secret-access-key";
    public static final String S3FILEIO_SESSION_TOKEN = "s3.session-token";
    public static final String DYNAMODB_TABLE_NAME = "dynamodb.table-name";
    public static final String DYNAMODB_TABLE_NAME_DEFAULT = "iceberg";
    public static final String CLIENT_FACTORY = "client.factory";
    public static final String CLIENT_ASSUME_ROLE_ARN = "client.assume-role.arn";
    public static final String CLIENT_ASSUME_ROLE_TIMEOUT_SEC = "client.assume-role.timeout-sec";
    public static final int CLIENT_ASSUME_ROLE_TIMEOUT_SEC_DEFAULT = 3600;
    public static final String CLIENT_ASSUME_ROLE_EXTERNAL_ID = "client.assume-role.external-id";
    public static final String CLIENT_ASSUME_ROLE_REGION = "client.assume-role.region";
    public static final String S3_CHECKSUM_ENABLED = "s3.checksum-enabled";
    public static final boolean CLIENT_ENABLE_ETAG_CHECK_DEFAULT = false;
    private String s3FileIoSseType;
    private String s3FileIoSseKey;
    private String s3FileIoSseMd5;
    private int s3FileIoMultipartUploadThreads;
    private int s3FileIoMultiPartSize;
    private double s3FileIoMultipartThresholdFactor;
    private String s3fileIoStagingDirectory;
    private ObjectCannedACL s3FileIoAcl;
    private String glueCatalogId;
    private boolean glueCatalogSkipArchive;
    private String dynamoDbTableName;
    private boolean isS3ChecksumEnabled;

    public AwsProperties() {
        this.s3FileIoSseType = S3FILEIO_SSE_TYPE_NONE;
        this.s3FileIoSseKey = null;
        this.s3FileIoSseMd5 = null;
        this.s3FileIoAcl = null;
        this.s3FileIoMultipartUploadThreads = Runtime.getRuntime().availableProcessors();
        this.s3FileIoMultiPartSize = 0x2000000;
        this.s3FileIoMultipartThresholdFactor = 1.5;
        this.s3fileIoStagingDirectory = System.getProperty("java.io.tmpdir");
        this.glueCatalogId = null;
        this.glueCatalogSkipArchive = false;
        this.dynamoDbTableName = DYNAMODB_TABLE_NAME_DEFAULT;
    }

    public AwsProperties(Map<String, String> properties) {
        this.s3FileIoSseType = properties.getOrDefault(S3FILEIO_SSE_TYPE, S3FILEIO_SSE_TYPE_NONE);
        this.s3FileIoSseKey = properties.get(S3FILEIO_SSE_KEY);
        this.s3FileIoSseMd5 = properties.get(S3FILEIO_SSE_MD5);
        if (S3FILEIO_SSE_TYPE_CUSTOM.equals(this.s3FileIoSseType)) {
            Preconditions.checkNotNull(this.s3FileIoSseKey, "Cannot initialize SSE-C S3FileIO with null encryption key");
            Preconditions.checkNotNull(this.s3FileIoSseMd5, "Cannot initialize SSE-C S3FileIO with null encryption key MD5");
        }
        this.glueCatalogId = properties.get(GLUE_CATALOG_ID);
        this.glueCatalogSkipArchive = PropertyUtil.propertyAsBoolean(properties, GLUE_CATALOG_SKIP_ARCHIVE, false);
        this.s3FileIoMultipartUploadThreads = PropertyUtil.propertyAsInt(properties, S3FILEIO_MULTIPART_UPLOAD_THREADS, Runtime.getRuntime().availableProcessors());
        try {
            this.s3FileIoMultiPartSize = PropertyUtil.propertyAsInt(properties, S3FILEIO_MULTIPART_SIZE, 0x2000000);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Input malformed or exceeded maximum multipart upload size 5GB: %s" + properties.get(S3FILEIO_MULTIPART_SIZE));
        }
        this.s3FileIoMultipartThresholdFactor = PropertyUtil.propertyAsDouble(properties, S3FILEIO_MULTIPART_THRESHOLD_FACTOR, 1.5);
        Preconditions.checkArgument(this.s3FileIoMultipartThresholdFactor >= 1.0, "Multipart threshold factor must be >= to 1.0");
        Preconditions.checkArgument(this.s3FileIoMultiPartSize >= 0x500000, "Minimum multipart upload object size must be larger than 5 MB.");
        this.s3fileIoStagingDirectory = PropertyUtil.propertyAsString(properties, S3FILEIO_STAGING_DIRECTORY, System.getProperty("java.io.tmpdir"));
        String aclType = properties.get(S3FILEIO_ACL);
        this.s3FileIoAcl = ObjectCannedACL.fromValue((String)aclType);
        Preconditions.checkArgument(this.s3FileIoAcl == null || !this.s3FileIoAcl.equals((Object)ObjectCannedACL.UNKNOWN_TO_SDK_VERSION), "Cannot support S3 CannedACL " + aclType);
        this.dynamoDbTableName = PropertyUtil.propertyAsString(properties, DYNAMODB_TABLE_NAME, DYNAMODB_TABLE_NAME_DEFAULT);
        this.isS3ChecksumEnabled = PropertyUtil.propertyAsBoolean(properties, S3_CHECKSUM_ENABLED, false);
    }

    public String s3FileIoSseType() {
        return this.s3FileIoSseType;
    }

    public void setS3FileIoSseType(String sseType) {
        this.s3FileIoSseType = sseType;
    }

    public String s3FileIoSseKey() {
        return this.s3FileIoSseKey;
    }

    public void setS3FileIoSseKey(String sseKey) {
        this.s3FileIoSseKey = sseKey;
    }

    public String s3FileIoSseMd5() {
        return this.s3FileIoSseMd5;
    }

    public void setS3FileIoSseMd5(String sseMd5) {
        this.s3FileIoSseMd5 = sseMd5;
    }

    public String glueCatalogId() {
        return this.glueCatalogId;
    }

    public void setGlueCatalogId(String id) {
        this.glueCatalogId = id;
    }

    public boolean glueCatalogSkipArchive() {
        return this.glueCatalogSkipArchive;
    }

    public void setGlueCatalogSkipArchive(boolean skipArchive) {
        this.glueCatalogSkipArchive = skipArchive;
    }

    public int s3FileIoMultipartUploadThreads() {
        return this.s3FileIoMultipartUploadThreads;
    }

    public void setS3FileIoMultipartUploadThreads(int threads) {
        this.s3FileIoMultipartUploadThreads = threads;
    }

    public int s3FileIoMultiPartSize() {
        return this.s3FileIoMultiPartSize;
    }

    public void setS3FileIoMultiPartSize(int size) {
        this.s3FileIoMultiPartSize = size;
    }

    public double s3FileIOMultipartThresholdFactor() {
        return this.s3FileIoMultipartThresholdFactor;
    }

    public void setS3FileIoMultipartThresholdFactor(double factor) {
        this.s3FileIoMultipartThresholdFactor = factor;
    }

    public String s3fileIoStagingDirectory() {
        return this.s3fileIoStagingDirectory;
    }

    public void setS3fileIoStagingDirectory(String directory) {
        this.s3fileIoStagingDirectory = directory;
    }

    public ObjectCannedACL s3FileIoAcl() {
        return this.s3FileIoAcl;
    }

    public void setS3FileIoAcl(ObjectCannedACL acl) {
        this.s3FileIoAcl = acl;
    }

    public String dynamoDbTableName() {
        return this.dynamoDbTableName;
    }

    public void setDynamoDbTableName(String name) {
        this.dynamoDbTableName = name;
    }

    public boolean isS3ChecksumEnabled() {
        return this.isS3ChecksumEnabled;
    }

    public void setS3ChecksumEnabled(boolean eTagCheckEnabled) {
        this.isS3ChecksumEnabled = eTagCheckEnabled;
    }
}

