/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.Rollback;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;

abstract class BaseMetadataTable
implements Table,
HasTableOperations,
Serializable {
    private final PartitionSpec spec = PartitionSpec.unpartitioned();
    private final SortOrder sortOrder = SortOrder.unsorted();
    private final TableOperations ops;
    private final Table table;
    private final String name;

    protected BaseMetadataTable(TableOperations ops, Table table, String name) {
        this.ops = ops;
        this.table = table;
        this.name = name;
    }

    static PartitionSpec transformSpec(Schema metadataTableSchema, PartitionSpec spec) {
        PartitionSpec.Builder identitySpecBuilder = PartitionSpec.builderFor(metadataTableSchema).checkConflicts(false);
        spec.fields().forEach(pf -> identitySpecBuilder.add(pf.fieldId(), pf.name(), "identity"));
        return identitySpecBuilder.build();
    }

    abstract MetadataTableType metadataTableType();

    protected Table table() {
        return this.table;
    }

    @Override
    public TableOperations operations() {
        return this.ops;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public FileIO io() {
        return this.table().io();
    }

    @Override
    public String location() {
        return this.table().location();
    }

    @Override
    public EncryptionManager encryption() {
        return this.table().encryption();
    }

    @Override
    public LocationProvider locationProvider() {
        return this.table().locationProvider();
    }

    @Override
    public void refresh() {
        this.table().refresh();
    }

    @Override
    public Map<Integer, Schema> schemas() {
        return ImmutableMap.of(0, this.schema());
    }

    @Override
    public PartitionSpec spec() {
        return this.spec;
    }

    @Override
    public Map<Integer, PartitionSpec> specs() {
        return ImmutableMap.of(this.spec.specId(), this.spec);
    }

    @Override
    public SortOrder sortOrder() {
        return this.sortOrder;
    }

    @Override
    public Map<Integer, SortOrder> sortOrders() {
        return ImmutableMap.of(this.sortOrder.orderId(), this.sortOrder);
    }

    @Override
    public Map<String, String> properties() {
        return ImmutableMap.of();
    }

    @Override
    public Snapshot currentSnapshot() {
        return this.table().currentSnapshot();
    }

    @Override
    public Iterable<Snapshot> snapshots() {
        return this.table().snapshots();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.table().snapshot(snapshotId);
    }

    @Override
    public List<HistoryEntry> history() {
        return this.table().history();
    }

    @Override
    public UpdateSchema updateSchema() {
        throw new UnsupportedOperationException("Cannot update the schema of a metadata table");
    }

    @Override
    public UpdatePartitionSpec updateSpec() {
        throw new UnsupportedOperationException("Cannot update the partition spec of a metadata table");
    }

    @Override
    public UpdateProperties updateProperties() {
        throw new UnsupportedOperationException("Cannot update the properties of a metadata table");
    }

    @Override
    public ReplaceSortOrder replaceSortOrder() {
        throw new UnsupportedOperationException("Cannot update the sort order of a metadata table");
    }

    @Override
    public UpdateLocation updateLocation() {
        throw new UnsupportedOperationException("Cannot update the location of a metadata table");
    }

    @Override
    public AppendFiles newAppend() {
        throw new UnsupportedOperationException("Cannot append to a metadata table");
    }

    @Override
    public RewriteFiles newRewrite() {
        throw new UnsupportedOperationException("Cannot rewrite in a metadata table");
    }

    @Override
    public RewriteManifests rewriteManifests() {
        throw new UnsupportedOperationException("Cannot rewrite manifests in a metadata table");
    }

    @Override
    public OverwriteFiles newOverwrite() {
        throw new UnsupportedOperationException("Cannot overwrite in a metadata table");
    }

    @Override
    public RowDelta newRowDelta() {
        throw new UnsupportedOperationException("Cannot remove or replace rows in a metadata table");
    }

    @Override
    public ReplacePartitions newReplacePartitions() {
        throw new UnsupportedOperationException("Cannot replace partitions in a metadata table");
    }

    @Override
    public DeleteFiles newDelete() {
        throw new UnsupportedOperationException("Cannot delete from a metadata table");
    }

    @Override
    public ExpireSnapshots expireSnapshots() {
        throw new UnsupportedOperationException("Cannot expire snapshots from a metadata table");
    }

    @Override
    public Rollback rollback() {
        throw new UnsupportedOperationException("Cannot roll back a metadata table");
    }

    @Override
    public ManageSnapshots manageSnapshots() {
        throw new UnsupportedOperationException("Cannot manage snapshots in a metadata table");
    }

    @Override
    public Transaction newTransaction() {
        throw new UnsupportedOperationException("Cannot create transactions for a metadata table");
    }

    public String toString() {
        return this.name();
    }

    final Object writeReplace() {
        return SerializableTable.copyOf(this);
    }
}

