/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.MultiGetContentsRequest;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MultiGetContentsRequest", generator="Immutables")
@Immutable
public final class ImmutableMultiGetContentsRequest
implements MultiGetContentsRequest {
    private final List<ContentsKey> requestedKeys;
    private final transient int hashCode;

    private ImmutableMultiGetContentsRequest(List<ContentsKey> requestedKeys) {
        this.requestedKeys = requestedKeys;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="requestedKeys")
    public List<ContentsKey> getRequestedKeys() {
        return this.requestedKeys;
    }

    public final ImmutableMultiGetContentsRequest withRequestedKeys(ContentsKey ... elements) {
        List<ContentsKey> newValue = ImmutableMultiGetContentsRequest.createUnmodifiableList(false, ImmutableMultiGetContentsRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMultiGetContentsRequest(newValue);
    }

    public final ImmutableMultiGetContentsRequest withRequestedKeys(Iterable<? extends ContentsKey> elements) {
        if (this.requestedKeys == elements) {
            return this;
        }
        List<ContentsKey> newValue = ImmutableMultiGetContentsRequest.createUnmodifiableList(false, ImmutableMultiGetContentsRequest.createSafeList(elements, true, false));
        return new ImmutableMultiGetContentsRequest(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMultiGetContentsRequest && this.equalTo((ImmutableMultiGetContentsRequest)another);
    }

    private boolean equalTo(ImmutableMultiGetContentsRequest another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.requestedKeys.equals(another.requestedKeys);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.requestedKeys.hashCode();
        return h2;
    }

    public String toString() {
        return "MultiGetContentsRequest{requestedKeys=" + this.requestedKeys + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMultiGetContentsRequest fromJson(Json json) {
        Builder builder = ImmutableMultiGetContentsRequest.builder();
        if (json.requestedKeys != null) {
            builder.addAllRequestedKeys(json.requestedKeys);
        }
        return builder.build();
    }

    public static ImmutableMultiGetContentsRequest copyOf(MultiGetContentsRequest instance) {
        if (instance instanceof ImmutableMultiGetContentsRequest) {
            return (ImmutableMultiGetContentsRequest)instance;
        }
        return ImmutableMultiGetContentsRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="MultiGetContentsRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<ContentsKey> requestedKeys = new ArrayList<ContentsKey>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MultiGetContentsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllRequestedKeys(instance.getRequestedKeys());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequestedKeys(ContentsKey element) {
            this.requestedKeys.add(Objects.requireNonNull(element, "requestedKeys element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequestedKeys(ContentsKey ... elements) {
            for (ContentsKey element : elements) {
                this.requestedKeys.add(Objects.requireNonNull(element, "requestedKeys element"));
            }
            return this;
        }

        @JsonProperty(value="requestedKeys")
        @CanIgnoreReturnValue
        public final Builder requestedKeys(Iterable<? extends ContentsKey> elements) {
            this.requestedKeys.clear();
            return this.addAllRequestedKeys(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRequestedKeys(Iterable<? extends ContentsKey> elements) {
            for (ContentsKey contentsKey : elements) {
                this.requestedKeys.add(Objects.requireNonNull(contentsKey, "requestedKeys element"));
            }
            return this;
        }

        public ImmutableMultiGetContentsRequest build() {
            return new ImmutableMultiGetContentsRequest(ImmutableMultiGetContentsRequest.createUnmodifiableList(true, this.requestedKeys));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MultiGetContentsRequest", generator="Immutables")
    static final class Json
    implements MultiGetContentsRequest {
        @Nullable
        List<ContentsKey> requestedKeys = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="requestedKeys")
        public void setRequestedKeys(List<ContentsKey> requestedKeys) {
            this.requestedKeys = requestedKeys;
        }

        @Override
        public List<ContentsKey> getRequestedKeys() {
            throw new UnsupportedOperationException();
        }
    }
}

