/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.model.Merge;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Merge", generator="Immutables")
@Immutable
public final class ImmutableMerge
implements Merge {
    private final String fromHash;
    private final transient int hashCode;

    private ImmutableMerge(String fromHash) {
        this.fromHash = fromHash;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="fromHash")
    @JsonFormat(pattern="^[0-9a-fA-F]{16,64}$")
    public String getFromHash() {
        return this.fromHash;
    }

    public final ImmutableMerge withFromHash(String value) {
        String newValue = Objects.requireNonNull(value, "fromHash");
        if (this.fromHash.equals(newValue)) {
            return this;
        }
        return ImmutableMerge.validate(new ImmutableMerge(newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMerge && this.equalTo((ImmutableMerge)another);
    }

    private boolean equalTo(ImmutableMerge another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.fromHash.equals(another.fromHash);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.fromHash.hashCode();
        return h2;
    }

    public String toString() {
        return "Merge{fromHash=" + this.fromHash + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMerge fromJson(Json json) {
        Builder builder = ImmutableMerge.builder();
        if (json.fromHash != null) {
            builder.fromHash(json.fromHash);
        }
        return builder.build();
    }

    private static ImmutableMerge validate(ImmutableMerge instance) {
        instance.checkHash();
        return instance;
    }

    public static ImmutableMerge copyOf(Merge instance) {
        if (instance instanceof ImmutableMerge) {
            return (ImmutableMerge)instance;
        }
        return ImmutableMerge.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Merge", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FROM_HASH = 1L;
        private long initBits = 1L;
        @Nullable
        private String fromHash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Merge instance) {
            Objects.requireNonNull(instance, "instance");
            this.fromHash(instance.getFromHash());
            return this;
        }

        @JsonProperty(value="fromHash")
        @JsonFormat(pattern="^[0-9a-fA-F]{16,64}$")
        @CanIgnoreReturnValue
        public final Builder fromHash(String fromHash) {
            this.fromHash = Objects.requireNonNull(fromHash, "fromHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMerge build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableMerge.validate(new ImmutableMerge(this.fromHash));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fromHash");
            }
            return "Cannot build Merge, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Merge", generator="Immutables")
    static final class Json
    implements Merge {
        @Nullable
        String fromHash;

        Json() {
        }

        @JsonProperty(value="fromHash")
        @JsonFormat(pattern="^[0-9a-fA-F]{16,64}$")
        public void setFromHash(String fromHash) {
            this.fromHash = fromHash;
        }

        @Override
        public String getFromHash() {
            throw new UnsupportedOperationException();
        }
    }
}

