/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class BinPacking {

    private static class Bin<T> {
        private final long targetWeight;
        private final List<T> items = Lists.newArrayList();
        private long binWeight = 0L;

        Bin(long targetWeight) {
            this.targetWeight = targetWeight;
        }

        List<T> items() {
            return this.items;
        }

        boolean canAdd(long weight) {
            return this.binWeight + weight <= this.targetWeight;
        }

        void add(T item, long weight) {
            this.binWeight += weight;
            this.items.add(item);
        }

        long weight() {
            return this.binWeight;
        }
    }

    private static class PackingIterator<T>
    implements Iterator<List<T>> {
        private final Deque<Bin<T>> bins = Lists.newLinkedList();
        private final Iterator<T> items;
        private final long targetWeight;
        private final int lookback;
        private final Function<T, Long> weightFunc;
        private final boolean largestBinFirst;

        private PackingIterator(Iterator<T> items, long targetWeight, int lookback, Function<T, Long> weightFunc, boolean largestBinFirst) {
            this.items = items;
            this.targetWeight = targetWeight;
            this.lookback = lookback;
            this.weightFunc = weightFunc;
            this.largestBinFirst = largestBinFirst;
        }

        @Override
        public boolean hasNext() {
            return this.items.hasNext() || !this.bins.isEmpty();
        }

        @Override
        public List<T> next() {
            while (this.items.hasNext()) {
                T item = this.items.next();
                long weight = this.weightFunc.apply(item);
                Bin<T> bin = this.findBin(weight);
                if (bin != null) {
                    bin.add(item, weight);
                    continue;
                }
                bin = this.newBin();
                bin.add(item, weight);
                this.bins.addLast(bin);
                if (this.bins.size() <= this.lookback) continue;
                Bin<T> binToRemove = this.largestBinFirst ? PackingIterator.removeLargestBin(this.bins) : this.bins.removeFirst();
                return ImmutableList.copyOf(binToRemove.items());
            }
            if (this.bins.isEmpty()) {
                throw new NoSuchElementException();
            }
            return ImmutableList.copyOf(this.bins.removeFirst().items());
        }

        private Bin<T> findBin(long weight) {
            for (Bin<T> bin : this.bins) {
                if (!bin.canAdd(weight)) continue;
                return bin;
            }
            return null;
        }

        private Bin<T> newBin() {
            return new Bin(this.targetWeight);
        }

        private static <T> Bin<T> removeLargestBin(Collection<Bin<T>> bins) {
            Bin maxBin = Collections.max(bins, Comparator.comparingLong(Bin::weight));
            if (bins.remove(maxBin)) {
                return maxBin;
            }
            throw new NoSuchElementException();
        }
    }

    public static class PackingIterable<T>
    implements Iterable<List<T>> {
        private final Iterable<T> iterable;
        private final long targetWeight;
        private final int lookback;
        private final Function<T, Long> weightFunc;
        private final boolean largestBinFirst;

        public PackingIterable(Iterable<T> iterable, long targetWeight, int lookback, Function<T, Long> weightFunc) {
            this(iterable, targetWeight, lookback, weightFunc, false);
        }

        public PackingIterable(Iterable<T> iterable, long targetWeight, int lookback, Function<T, Long> weightFunc, boolean largestBinFirst) {
            Preconditions.checkArgument(lookback > 0, "Bin look-back size must be greater than 0: %s", lookback);
            this.iterable = iterable;
            this.targetWeight = targetWeight;
            this.lookback = lookback;
            this.weightFunc = weightFunc;
            this.largestBinFirst = largestBinFirst;
        }

        @Override
        public Iterator<List<T>> iterator() {
            return new PackingIterator(this.iterable.iterator(), this.targetWeight, this.lookback, this.weightFunc, this.largestBinFirst);
        }
    }

    public static class ListPacker<T> {
        private final long targetWeight;
        private final int lookback;
        private final boolean largestBinFirst;

        public ListPacker(long targetWeight, int lookback, boolean largestBinFirst) {
            this.targetWeight = targetWeight;
            this.lookback = lookback;
            this.largestBinFirst = largestBinFirst;
        }

        public List<List<T>> packEnd(List<T> items, Function<T, Long> weightFunc) {
            return Lists.reverse(ImmutableList.copyOf(Iterables.transform(new PackingIterable<T>(Lists.reverse(items), this.targetWeight, this.lookback, weightFunc, this.largestBinFirst), Lists::reverse)));
        }

        public List<List<T>> pack(Iterable<T> items, Function<T, Long> weightFunc) {
            return ImmutableList.copyOf(new PackingIterable<T>(items, this.targetWeight, this.lookback, weightFunc, this.largestBinFirst));
        }
    }
}

