/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.types.Types;

public class MetadataColumns {
    public static final Types.NestedField FILE_PATH = Types.NestedField.required(0x7FFFFFFE, "_file", Types.StringType.get(), "Path of the file in which a row is stored");
    public static final Types.NestedField ROW_POSITION = Types.NestedField.required(0x7FFFFFFD, "_pos", Types.LongType.get(), "Ordinal position of a row in the source data file");
    public static final Types.NestedField IS_DELETED = Types.NestedField.required(0x7FFFFFFC, "_deleted", Types.BooleanType.get(), "Whether the row has been deleted");
    public static final Types.NestedField DELETE_FILE_PATH = Types.NestedField.required(2147483546, "file_path", Types.StringType.get(), "Path of a file in which a deleted row is stored");
    public static final Types.NestedField DELETE_FILE_POS = Types.NestedField.required(0x7FFFFF99, "pos", Types.LongType.get(), "Ordinal position of a deleted row in the data file");
    public static final String DELETE_FILE_ROW_FIELD_NAME = "row";
    public static final int DELETE_FILE_ROW_FIELD_ID = 2147483544;
    public static final String DELETE_FILE_ROW_DOC = "Deleted row values";
    private static final Map<String, Types.NestedField> META_COLUMNS = ImmutableMap.of(FILE_PATH.name(), FILE_PATH, ROW_POSITION.name(), ROW_POSITION, IS_DELETED.name(), IS_DELETED);
    private static final Set<Integer> META_IDS = META_COLUMNS.values().stream().map(Types.NestedField::fieldId).collect(ImmutableSet.toImmutableSet());

    private MetadataColumns() {
    }

    public static Set<Integer> metadataFieldIds() {
        return META_IDS;
    }

    public static Types.NestedField get(String name) {
        return META_COLUMNS.get(name);
    }

    public static boolean isMetadataColumn(String name) {
        return META_COLUMNS.containsKey(name);
    }

    public static boolean nonMetadataColumn(String name) {
        return !META_COLUMNS.containsKey(name);
    }
}

