/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.avro.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.iceberg.shaded.org.apache.avro.AvroRuntimeException;
import org.apache.iceberg.shaded.org.apache.avro.io.BinaryData;
import org.slf4j.LoggerFactory;

public class Utf8
implements Comparable<Utf8>,
CharSequence {
    private static final String MAX_LENGTH_PROPERTY = "org.apache.iceberg.shaded.org.apache.avro.limits.string.maxLength";
    private static final int MAX_LENGTH;
    private static final byte[] EMPTY;
    private byte[] bytes;
    private int hash;
    private int length;
    private String string;

    public Utf8() {
        this.bytes = EMPTY;
    }

    public Utf8(String string) {
        byte[] bytes = Utf8.getBytesFor(string);
        int length = bytes.length;
        Utf8.checkLength(length);
        this.bytes = bytes;
        this.length = length;
        this.string = string;
    }

    public Utf8(Utf8 other) {
        this.length = other.length;
        this.bytes = Arrays.copyOf(other.bytes, other.length);
        this.string = other.string;
        this.hash = other.hash;
    }

    public Utf8(byte[] bytes) {
        int length = bytes.length;
        Utf8.checkLength(length);
        this.bytes = bytes;
        this.length = length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Deprecated
    public int getLength() {
        return this.length;
    }

    public int getByteLength() {
        return this.length;
    }

    @Deprecated
    public Utf8 setLength(int newLength) {
        return this.setByteLength(newLength);
    }

    public Utf8 setByteLength(int newLength) {
        Utf8.checkLength(newLength);
        if (this.bytes.length < newLength) {
            this.bytes = Arrays.copyOf(this.bytes, newLength);
        }
        this.length = newLength;
        this.string = null;
        this.hash = 0;
        return this;
    }

    public Utf8 set(String string) {
        byte[] bytes = Utf8.getBytesFor(string);
        int length = bytes.length;
        Utf8.checkLength(length);
        this.bytes = bytes;
        this.length = length;
        this.string = string;
        this.hash = 0;
        return this;
    }

    public Utf8 set(Utf8 other) {
        if (this.bytes.length < other.length) {
            this.bytes = new byte[other.length];
        }
        this.length = other.length;
        System.arraycopy(other.bytes, 0, this.bytes, 0, this.length);
        this.string = other.string;
        this.hash = other.hash;
        return this;
    }

    @Override
    public String toString() {
        if (this.length == 0) {
            return "";
        }
        if (this.string == null) {
            this.string = new String(this.bytes, 0, this.length, StandardCharsets.UTF_8);
        }
        return this.string;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Utf8)) {
            return false;
        }
        Utf8 that = (Utf8)o;
        if (this.length != that.length) {
            return false;
        }
        byte[] thatBytes = that.bytes;
        for (int i = 0; i < this.length; ++i) {
            if (this.bytes[i] == thatBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0) {
            byte[] bytes = this.bytes;
            int length = this.length;
            for (int i = 0; i < length; ++i) {
                h2 = h2 * 31 + bytes[i];
            }
            this.hash = h2;
        }
        return h2;
    }

    @Override
    public int compareTo(Utf8 that) {
        return BinaryData.compareBytes(this.bytes, 0, this.length, that.bytes, 0, that.length);
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    private static void checkLength(int length) {
        if (length > MAX_LENGTH) {
            throw new AvroRuntimeException("String length " + length + " exceeds maximum allowed");
        }
    }

    public static byte[] getBytesFor(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    static {
        EMPTY = new byte[0];
        String o = System.getProperty(MAX_LENGTH_PROPERTY);
        int i = Integer.MAX_VALUE;
        if (o != null) {
            try {
                i = Integer.parseUnsignedInt(o);
            }
            catch (NumberFormatException nfe) {
                LoggerFactory.getLogger(Utf8.class).warn("Could not parse property org.apache.avro.limits.string.maxLength: " + o, (Throwable)nfe);
            }
        }
        MAX_LENGTH = i;
    }
}

