/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.util.Objects;
import org.projectnessie.api.TreeApi;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Hash;
import org.projectnessie.model.Reference;

class UpdateableReference {
    private Reference reference;
    private final TreeApi client;

    UpdateableReference(Reference reference, TreeApi client) {
        this.reference = reference;
        this.client = client;
    }

    public boolean refresh() throws NessieNotFoundException {
        if (this.reference instanceof Hash) {
            return false;
        }
        Reference oldReference = this.reference;
        this.reference = this.client.getReferenceByName(this.reference.getName());
        return !oldReference.equals(this.reference);
    }

    public void updateReference(Reference ref) {
        Objects.requireNonNull(ref);
        this.reference = ref;
    }

    public boolean isBranch() {
        return this.reference instanceof Branch;
    }

    public UpdateableReference copy() {
        return new UpdateableReference(this.reference, this.client);
    }

    public String getHash() {
        return this.reference.getHash();
    }

    public Branch getAsBranch() {
        if (!this.isBranch()) {
            throw new IllegalArgumentException("Reference is not a branch");
        }
        return (Branch)this.reference;
    }

    public void checkMutable() {
        if (!this.isBranch()) {
            throw new IllegalArgumentException("You can only mutate tables when using a branch.");
        }
    }

    public String getName() {
        return this.reference.getName();
    }
}

