/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.mr.mapreduce.IcebergSplitContainer;
import org.apache.iceberg.util.SerializationUtil;

public class IcebergSplit
extends InputSplit
implements org.apache.hadoop.mapred.InputSplit,
IcebergSplitContainer {
    public static final String[] ANYWHERE = new String[]{"*"};
    private CombinedScanTask task;
    private FileIO io;
    private EncryptionManager encryptionManager;
    private transient String[] locations;
    private transient Configuration conf;

    public IcebergSplit() {
    }

    IcebergSplit(Configuration conf, CombinedScanTask task, FileIO io, EncryptionManager encryptionManager) {
        this.task = task;
        this.conf = conf;
        this.io = io;
        this.encryptionManager = encryptionManager;
    }

    public CombinedScanTask task() {
        return this.task;
    }

    @Override
    public IcebergSplit icebergSplit() {
        return this;
    }

    public long getLength() {
        return this.task.files().stream().mapToLong(FileScanTask::length).sum();
    }

    public String[] getLocations() {
        boolean localityPreferred;
        this.locations = this.locations == null && this.conf != null ? ((localityPreferred = this.conf.getBoolean("iceberg.mr.locality", false)) ? Util.blockLocations(this.task, this.conf) : ANYWHERE) : ANYWHERE;
        return this.locations;
    }

    public void write(DataOutput out) throws IOException {
        byte[] data = SerializationUtil.serializeToBytes(this.task);
        out.writeInt(data.length);
        out.write(data);
        byte[] ioData = SerializationUtil.serializeToBytes(this.io);
        out.writeInt(ioData.length);
        out.write(ioData);
        byte[] encryptionManagerData = SerializationUtil.serializeToBytes(this.encryptionManager);
        out.writeInt(encryptionManagerData.length);
        out.write(encryptionManagerData);
    }

    public void readFields(DataInput in) throws IOException {
        byte[] data = new byte[in.readInt()];
        in.readFully(data);
        this.task = (CombinedScanTask)SerializationUtil.deserializeFromBytes(data);
        byte[] ioData = new byte[in.readInt()];
        in.readFully(ioData);
        this.io = (FileIO)SerializationUtil.deserializeFromBytes(ioData);
        byte[] encryptionManagerData = new byte[in.readInt()];
        in.readFully(encryptionManagerData);
        this.encryptionManager = (EncryptionManager)SerializationUtil.deserializeFromBytes(encryptionManagerData);
    }

    public FileIO io() {
        return this.io;
    }

    public EncryptionManager encryptionManager() {
        return this.encryptionManager;
    }
}

