/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.mr.InputFormatConfig;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;

public final class Catalogs {
    public static final String ICEBERG_DEFAULT_CATALOG_NAME = "default_iceberg";
    public static final String ICEBERG_HADOOP_TABLE_NAME = "location_based_table";
    public static final String NAME = "name";
    public static final String LOCATION = "location";
    private static final String NO_CATALOG_TYPE = "no catalog";
    private static final Set<String> PROPERTIES_TO_REMOVE = ImmutableSet.of("iceberg.mr.table.schema", "iceberg.mr.table.partition.spec", "location", "name", "iceberg.catalog");

    private Catalogs() {
    }

    public static Table loadTable(Configuration conf) {
        return Catalogs.loadTable(conf, conf.get("iceberg.mr.table.identifier"), conf.get("iceberg.mr.table.location"), conf.get("iceberg.catalog"));
    }

    public static Table loadTable(Configuration conf, Properties props) {
        return Catalogs.loadTable(conf, props.getProperty(NAME), props.getProperty(LOCATION), props.getProperty("iceberg.catalog"));
    }

    private static Table loadTable(Configuration conf, String tableIdentifier, String tableLocation, String catalogName) {
        Optional<Catalog> catalog = Catalogs.loadCatalog(conf, catalogName);
        if (catalog.isPresent()) {
            Preconditions.checkArgument(tableIdentifier != null, "Table identifier not set");
            return catalog.get().loadTable(TableIdentifier.parse(tableIdentifier));
        }
        Preconditions.checkArgument(tableLocation != null, "Table location not set");
        return new HadoopTables(conf).load(tableLocation);
    }

    public static Table createTable(Configuration conf, Properties props) {
        String schemaString = props.getProperty("iceberg.mr.table.schema");
        Preconditions.checkNotNull(schemaString, "Table schema not set");
        Schema schema = SchemaParser.fromJson(props.getProperty("iceberg.mr.table.schema"));
        String specString = props.getProperty("iceberg.mr.table.partition.spec");
        PartitionSpec spec = PartitionSpec.unpartitioned();
        if (specString != null) {
            spec = PartitionSpecParser.fromJson(schema, specString);
        }
        String location = props.getProperty(LOCATION);
        String catalogName = props.getProperty("iceberg.catalog");
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (Object key : props.keySet()) {
            if (PROPERTIES_TO_REMOVE.contains(key)) continue;
            map.put(key.toString(), props.get(key).toString());
        }
        Optional<Catalog> catalog = Catalogs.loadCatalog(conf, catalogName);
        if (catalog.isPresent()) {
            String name = props.getProperty(NAME);
            Preconditions.checkNotNull(name, "Table identifier not set");
            return catalog.get().createTable(TableIdentifier.parse(name), schema, spec, location, map);
        }
        Preconditions.checkNotNull(location, "Table location not set");
        return new HadoopTables(conf).create(schema, spec, map, location);
    }

    public static boolean dropTable(Configuration conf, Properties props) {
        String location = props.getProperty(LOCATION);
        String catalogName = props.getProperty("iceberg.catalog");
        Optional<Catalog> catalog = Catalogs.loadCatalog(conf, catalogName);
        if (catalog.isPresent()) {
            String name = props.getProperty(NAME);
            Preconditions.checkNotNull(name, "Table identifier not set");
            return catalog.get().dropTable(TableIdentifier.parse(name));
        }
        Preconditions.checkNotNull(location, "Table location not set");
        return new HadoopTables(conf).dropTable(location);
    }

    public static boolean hiveCatalog(Configuration conf, Properties props) {
        String catalogName = props.getProperty("iceberg.catalog");
        return "hive".equalsIgnoreCase(Catalogs.getCatalogType(conf, catalogName));
    }

    @VisibleForTesting
    static Optional<Catalog> loadCatalog(Configuration conf, String catalogName) {
        String catalogType = Catalogs.getCatalogType(conf, catalogName);
        if (NO_CATALOG_TYPE.equalsIgnoreCase(catalogType)) {
            return Optional.empty();
        }
        String name = catalogName == null ? ICEBERG_DEFAULT_CATALOG_NAME : catalogName;
        return Optional.of(CatalogUtil.buildIcebergCatalog(name, Catalogs.getCatalogProperties(conf, name, catalogType), conf));
    }

    private static Map<String, String> getCatalogProperties(Configuration conf, String catalogName, String catalogType) {
        String keyPrefix = "iceberg.catalog." + catalogName;
        Map<String, String> catalogProperties = Streams.stream(conf.iterator()).filter(e -> ((String)e.getKey()).startsWith(keyPrefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(keyPrefix.length() + 1), Map.Entry::getValue));
        return Catalogs.addCatalogPropertiesIfMissing(conf, catalogType, catalogProperties);
    }

    private static Map<String, String> addCatalogPropertiesIfMissing(Configuration conf, String catalogType, Map<String, String> catalogProperties) {
        String legacyWarehouseLocation;
        String legacyCatalogImpl;
        if (catalogType != null) {
            catalogProperties.putIfAbsent("type", catalogType);
        }
        if ((legacyCatalogImpl = conf.get("iceberg.mr.catalog.loader.class")) != null) {
            catalogProperties.putIfAbsent("catalog-impl", legacyCatalogImpl);
        }
        if ((legacyWarehouseLocation = conf.get("iceberg.mr.catalog.hadoop.warehouse.location")) != null) {
            catalogProperties.putIfAbsent("warehouse", legacyWarehouseLocation);
        }
        return catalogProperties;
    }

    private static String getCatalogType(Configuration conf, String catalogName) {
        if (catalogName != null) {
            String catalogType = conf.get(InputFormatConfig.catalogPropertyConfigKey(catalogName, "type"));
            if (catalogName.equals(ICEBERG_HADOOP_TABLE_NAME)) {
                return NO_CATALOG_TYPE;
            }
            return catalogType;
        }
        String catalogType = conf.get("iceberg.mr.catalog");
        if (catalogType == null) {
            return "hive";
        }
        if (catalogType.equals(LOCATION)) {
            return NO_CATALOG_TYPE;
        }
        return catalogType;
    }
}

