/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mapping;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.MappedFields;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

public class NameMapping
implements Serializable {
    private static final Joiner DOT = Joiner.on('.');
    private final MappedFields mapping;
    private transient Map<Integer, MappedField> fieldsById;
    private transient Map<String, MappedField> fieldsByName;

    public static NameMapping of(MappedField ... fields) {
        return new NameMapping(MappedFields.of(ImmutableList.copyOf(fields)));
    }

    public static NameMapping of(List<MappedField> fields) {
        return new NameMapping(MappedFields.of(fields));
    }

    public static NameMapping of(MappedFields fields) {
        return new NameMapping(fields);
    }

    NameMapping(MappedFields mapping) {
        this.mapping = mapping;
        this.lazyFieldsById();
        this.lazyFieldsByName();
    }

    public MappedField find(int id) {
        return this.lazyFieldsById().get(id);
    }

    public MappedField find(String ... names) {
        return this.lazyFieldsByName().get(DOT.join(names));
    }

    public MappedField find(List<String> names) {
        return this.lazyFieldsByName().get(DOT.join(names));
    }

    public MappedFields asMappedFields() {
        return this.mapping;
    }

    private Map<Integer, MappedField> lazyFieldsById() {
        if (this.fieldsById == null) {
            this.fieldsById = MappingUtil.indexById(this.mapping);
        }
        return this.fieldsById;
    }

    private Map<String, MappedField> lazyFieldsByName() {
        if (this.fieldsByName == null) {
            this.fieldsByName = MappingUtil.indexByName(this.mapping);
        }
        return this.fieldsByName;
    }

    public String toString() {
        if (this.mapping.fields().isEmpty()) {
            return "[]";
        }
        return "[\n  " + Joiner.on("\n  ").join(this.mapping.fields()) + "\n]";
    }
}

