/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.DeleteFileIndex;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestFilterManager;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.ManifestMergeManager;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotProducer;
import org.apache.iceberg.SnapshotSummary;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.events.CreateSnapshotEvent;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Predicate;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MergingSnapshotProducer<ThisT>
extends SnapshotProducer<ThisT> {
    private static final Logger LOG = LoggerFactory.getLogger(MergingSnapshotProducer.class);
    private static final Set<String> VALIDATE_ADDED_FILES_OPERATIONS = ImmutableSet.of("append", "overwrite");
    private static final Set<String> VALIDATE_DATA_FILES_EXIST_OPERATIONS = ImmutableSet.of("overwrite", "replace", "delete");
    private static final Set<String> VALIDATE_DATA_FILES_EXIST_SKIP_DELETE_OPERATIONS = ImmutableSet.of("overwrite", "replace");
    private static final Set<String> VALIDATE_REPLACED_DATA_FILES_OPERATIONS = ImmutableSet.of("overwrite", "delete");
    private final String tableName;
    private final TableOperations ops;
    private final SnapshotSummary.Builder summaryBuilder = SnapshotSummary.builder();
    private final ManifestMergeManager<DataFile> mergeManager;
    private final ManifestFilterManager<DataFile> filterManager;
    private final ManifestMergeManager<DeleteFile> deleteMergeManager;
    private final ManifestFilterManager<DeleteFile> deleteFilterManager;
    private final boolean snapshotIdInheritanceEnabled;
    private final List<DataFile> newFiles = Lists.newArrayList();
    private final List<DeleteFile> newDeleteFiles = Lists.newArrayList();
    private final List<ManifestFile> appendManifests = Lists.newArrayList();
    private final List<ManifestFile> rewrittenAppendManifests = Lists.newArrayList();
    private final SnapshotSummary.Builder addedFilesSummary = SnapshotSummary.builder();
    private final SnapshotSummary.Builder appendedManifestsSummary = SnapshotSummary.builder();
    private Expression deleteExpression = Expressions.alwaysFalse();
    private PartitionSpec spec;
    private ManifestFile cachedNewManifest = null;
    private boolean hasNewFiles = false;
    private ManifestFile cachedNewDeleteManifest = null;
    private boolean hasNewDeleteFiles = false;

    MergingSnapshotProducer(String tableName, TableOperations ops) {
        super(ops);
        this.tableName = tableName;
        this.ops = ops;
        this.spec = null;
        long targetSizeBytes = ops.current().propertyAsLong("commit.manifest.target-size-bytes", 0x800000L);
        int minCountToMerge = ops.current().propertyAsInt("commit.manifest.min-count-to-merge", 100);
        boolean mergeEnabled = ops.current().propertyAsBoolean("commit.manifest-merge.enabled", true);
        this.mergeManager = new DataFileMergeManager(targetSizeBytes, minCountToMerge, mergeEnabled);
        this.filterManager = new DataFileFilterManager();
        this.deleteMergeManager = new DeleteFileMergeManager(targetSizeBytes, minCountToMerge, mergeEnabled);
        this.deleteFilterManager = new DeleteFileFilterManager();
        this.snapshotIdInheritanceEnabled = ops.current().propertyAsBoolean("compatibility.snapshot-id-inheritance.enabled", false);
    }

    @Override
    public ThisT set(String property, String value) {
        this.summaryBuilder.set(property, value);
        return this.self();
    }

    protected PartitionSpec writeSpec() {
        Preconditions.checkState(this.spec != null, "Cannot determine partition spec: no data or delete files have been added");
        return this.spec;
    }

    protected Expression rowFilter() {
        return this.deleteExpression;
    }

    protected List<DataFile> addedFiles() {
        return ImmutableList.copyOf(this.newFiles);
    }

    protected void failAnyDelete() {
        this.filterManager.failAnyDelete();
        this.deleteFilterManager.failAnyDelete();
    }

    protected void failMissingDeletePaths() {
        this.filterManager.failMissingDeletePaths();
        this.deleteFilterManager.failMissingDeletePaths();
    }

    protected void deleteByRowFilter(Expression expr) {
        this.deleteExpression = expr;
        this.filterManager.deleteByRowFilter(expr);
        this.deleteFilterManager.deleteByRowFilter(expr);
    }

    protected void dropPartition(int specId, StructLike partition) {
        this.filterManager.dropPartition(specId, partition);
        this.deleteFilterManager.dropPartition(specId, partition);
    }

    protected void delete(DataFile file) {
        this.filterManager.delete(file);
    }

    protected void delete(DeleteFile file) {
        this.deleteFilterManager.delete(file);
    }

    protected void delete(CharSequence path) {
        this.filterManager.delete(path);
    }

    protected void add(DataFile file) {
        this.setWriteSpec(file);
        this.addedFilesSummary.addedFile(this.writeSpec(), file);
        this.hasNewFiles = true;
        this.newFiles.add(file);
    }

    protected void add(DeleteFile file) {
        this.setWriteSpec(file);
        this.addedFilesSummary.addedFile(this.writeSpec(), file);
        this.hasNewDeleteFiles = true;
        this.newDeleteFiles.add(file);
    }

    private void setWriteSpec(ContentFile<?> file) {
        Preconditions.checkNotNull(file, "Invalid content file: null");
        PartitionSpec writeSpec = this.ops.current().spec(file.specId());
        Preconditions.checkNotNull(writeSpec, "Cannot find partition spec for file: %s", (Object)file.path());
        if (this.spec == null) {
            this.spec = writeSpec;
        } else if (this.spec.specId() != file.specId()) {
            throw new ValidationException("Invalid file, expected spec id: %d", this.spec.specId());
        }
    }

    protected void add(ManifestFile manifest) {
        Preconditions.checkArgument(manifest.content() == ManifestContent.DATA, "Cannot append delete manifest: %s", (Object)manifest);
        if (this.snapshotIdInheritanceEnabled && manifest.snapshotId() == null) {
            this.appendedManifestsSummary.addedManifest(manifest);
            this.appendManifests.add(manifest);
        } else {
            ManifestFile copiedManifest = this.copyManifest(manifest);
            this.rewrittenAppendManifests.add(copiedManifest);
        }
    }

    private ManifestFile copyManifest(ManifestFile manifest) {
        TableMetadata current = this.ops.current();
        InputFile toCopy = this.ops.io().newInputFile(manifest.path());
        OutputFile newManifestPath = this.newManifestOutput();
        return ManifestFiles.copyAppendManifest(current.formatVersion(), toCopy, current.specsById(), newManifestPath, this.snapshotId(), this.appendedManifestsSummary);
    }

    protected void validateAddedDataFiles(TableMetadata base, Long startingSnapshotId, Expression conflictDetectionFilter, boolean caseSensitive) {
        if (base.currentSnapshot() == null) {
            return;
        }
        Pair<List<ManifestFile>, Set<Long>> history = this.validationHistory(base, startingSnapshotId, VALIDATE_ADDED_FILES_OPERATIONS, ManifestContent.DATA);
        List<ManifestFile> manifests = history.first();
        Set<Long> newSnapshots = history.second();
        ManifestGroup conflictGroup = new ManifestGroup(this.ops.io(), manifests, ImmutableList.of()).caseSensitive(caseSensitive).filterManifestEntries(entry -> newSnapshots.contains(entry.snapshotId())).filterData(conflictDetectionFilter).specsById(base.specsById()).ignoreDeleted().ignoreExisting();
        try (Iterator conflicts = conflictGroup.entries().iterator();){
            if (conflicts.hasNext()) {
                throw new ValidationException("Found conflicting files that can contain records matching %s: %s", conflictDetectionFilter, Iterators.toString(Iterators.transform(conflicts, entry -> ((DataFile)entry.file()).path().toString())));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to validate no appends matching %s", conflictDetectionFilter), e);
        }
    }

    protected void validateNoNewDeletesForDataFiles(TableMetadata base, Long startingSnapshotId, Iterable<DataFile> dataFiles) {
        if (base.currentSnapshot() == null) {
            return;
        }
        Pair<List<ManifestFile>, Set<Long>> history = this.validationHistory(base, startingSnapshotId, VALIDATE_REPLACED_DATA_FILES_OPERATIONS, ManifestContent.DELETES);
        List<ManifestFile> deleteManifests = history.first();
        long startingSequenceNumber = startingSnapshotId == null ? 0L : base.snapshot(startingSnapshotId).sequenceNumber();
        DeleteFileIndex deletes = DeleteFileIndex.builderFor(this.ops.io(), deleteManifests).afterSequenceNumber(startingSequenceNumber).specsById(this.ops.current().specsById()).build();
        for (DataFile dataFile : dataFiles) {
            if (deletes.forDataFile(startingSequenceNumber, dataFile).length <= 0) continue;
            throw new ValidationException("Cannot commit, found new delete for replaced data file: %s", dataFile);
        }
    }

    protected void validateDataFilesExist(TableMetadata base, Long startingSnapshotId, CharSequenceSet requiredDataFiles, boolean skipDeletes) {
        if (base.currentSnapshot() == null) {
            return;
        }
        Set<String> matchingOperations = skipDeletes ? VALIDATE_DATA_FILES_EXIST_SKIP_DELETE_OPERATIONS : VALIDATE_DATA_FILES_EXIST_OPERATIONS;
        Pair<List<ManifestFile>, Set<Long>> history = this.validationHistory(base, startingSnapshotId, matchingOperations, ManifestContent.DATA);
        List<ManifestFile> manifests = history.first();
        Set<Long> newSnapshots = history.second();
        ManifestGroup matchingDeletesGroup = new ManifestGroup(this.ops.io(), manifests, ImmutableList.of()).filterManifestEntries(entry -> entry.status() != ManifestEntry.Status.ADDED && newSnapshots.contains(entry.snapshotId()) && requiredDataFiles.contains(((DataFile)entry.file()).path())).specsById(base.specsById()).ignoreExisting();
        try (Iterator deletes = matchingDeletesGroup.entries().iterator();){
            if (deletes.hasNext()) {
                throw new ValidationException("Cannot commit, missing data files: %s", Iterators.toString(Iterators.transform(deletes, entry -> ((DataFile)entry.file()).path().toString())));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to validate required files exist", e);
        }
    }

    private Pair<List<ManifestFile>, Set<Long>> validationHistory(TableMetadata base, Long startingSnapshotId, Set<String> matchingOperations, ManifestContent content) {
        ArrayList<ManifestFile> manifests = Lists.newArrayList();
        HashSet<Long> newSnapshots = Sets.newHashSet();
        Long currentSnapshotId = base.currentSnapshot().snapshotId();
        while (currentSnapshotId != null && !currentSnapshotId.equals(startingSnapshotId)) {
            Snapshot currentSnapshot = this.ops.current().snapshot(currentSnapshotId);
            ValidationException.check(currentSnapshot != null, "Cannot determine history between starting snapshot %s and current %s", startingSnapshotId, currentSnapshotId);
            if (matchingOperations.contains(currentSnapshot.operation())) {
                newSnapshots.add(currentSnapshotId);
                if (content == ManifestContent.DATA) {
                    for (ManifestFile manifest : currentSnapshot.dataManifests()) {
                        if (manifest.snapshotId().longValue() != currentSnapshotId.longValue()) continue;
                        manifests.add(manifest);
                    }
                } else {
                    for (ManifestFile manifest : currentSnapshot.deleteManifests()) {
                        if (manifest.snapshotId().longValue() != currentSnapshotId.longValue()) continue;
                        manifests.add(manifest);
                    }
                }
            }
            currentSnapshotId = currentSnapshot.parentId();
        }
        return Pair.of(manifests, newSnapshots);
    }

    @Override
    protected Map<String, String> summary() {
        this.summaryBuilder.setPartitionSummaryLimit(this.ops.current().propertyAsInt("write.summary.partition-limit", 0));
        return this.summaryBuilder.build();
    }

    @Override
    public List<ManifestFile> apply(TableMetadata base) {
        Snapshot current = base.currentSnapshot();
        List<ManifestFile> filtered = this.filterManager.filterManifests(base.schema(), current != null ? current.dataManifests() : null);
        long minDataSequenceNumber = filtered.stream().map(ManifestFile::minSequenceNumber).filter(seq -> seq > 0L).reduce(base.lastSequenceNumber(), Math::min);
        this.deleteFilterManager.dropDeleteFilesOlderThan(minDataSequenceNumber);
        List<ManifestFile> filteredDeletes = this.deleteFilterManager.filterManifests(base.schema(), current != null ? current.deleteManifests() : null);
        Predicate shouldKeep = manifest -> manifest.hasAddedFiles() || manifest.hasExistingFiles() || manifest.snapshotId().longValue() == this.snapshotId();
        Iterable<ManifestFile> unmergedManifests = Iterables.filter(Iterables.concat(this.prepareNewManifests(), filtered), shouldKeep);
        Iterable<ManifestFile> unmergedDeleteManifests = Iterables.filter(Iterables.concat(this.prepareDeleteManifests(), filteredDeletes), shouldKeep);
        this.summaryBuilder.clear();
        this.summaryBuilder.merge(this.addedFilesSummary);
        this.summaryBuilder.merge(this.appendedManifestsSummary);
        this.summaryBuilder.merge(this.filterManager.buildSummary(filtered));
        this.summaryBuilder.merge(this.deleteFilterManager.buildSummary(filteredDeletes));
        ArrayList<ManifestFile> manifests = Lists.newArrayList();
        Iterables.addAll(manifests, this.mergeManager.mergeManifests(unmergedManifests));
        Iterables.addAll(manifests, this.deleteMergeManager.mergeManifests(unmergedDeleteManifests));
        return manifests;
    }

    @Override
    public Object updateEvent() {
        long snapshotId = this.snapshotId();
        Snapshot justSaved = this.ops.refresh().snapshot(snapshotId);
        long sequenceNumber = -1L;
        if (justSaved == null) {
            LOG.warn("Failed to load committed snapshot: omitting sequence number from notifications");
        } else {
            sequenceNumber = justSaved.sequenceNumber();
        }
        return new CreateSnapshotEvent(this.tableName, this.operation(), snapshotId, sequenceNumber, this.summary());
    }

    private void cleanUncommittedAppends(Set<ManifestFile> committed) {
        if (this.cachedNewManifest != null && !committed.contains(this.cachedNewManifest)) {
            this.deleteFile(this.cachedNewManifest.path());
            this.cachedNewManifest = null;
        }
        if (this.cachedNewDeleteManifest != null && !committed.contains(this.cachedNewDeleteManifest)) {
            this.deleteFile(this.cachedNewDeleteManifest.path());
            this.cachedNewDeleteManifest = null;
        }
        for (ManifestFile manifest : this.rewrittenAppendManifests) {
            if (committed.contains(manifest)) continue;
            this.deleteFile(manifest.path());
        }
        if (!committed.isEmpty()) {
            for (ManifestFile manifest : this.appendManifests) {
                if (committed.contains(manifest)) continue;
                this.deleteFile(manifest.path());
            }
        }
    }

    @Override
    protected void cleanUncommitted(Set<ManifestFile> committed) {
        this.mergeManager.cleanUncommitted(committed);
        this.filterManager.cleanUncommitted(committed);
        this.deleteMergeManager.cleanUncommitted(committed);
        this.deleteFilterManager.cleanUncommitted(committed);
        this.cleanUncommittedAppends(committed);
    }

    private Iterable<ManifestFile> prepareNewManifests() {
        Iterable<ManifestFile> newManifests;
        if (this.newFiles.size() > 0) {
            ManifestFile newManifest = this.newFilesAsManifest();
            newManifests = Iterables.concat(ImmutableList.of(newManifest), this.appendManifests, this.rewrittenAppendManifests);
        } else {
            newManifests = Iterables.concat(this.appendManifests, this.rewrittenAppendManifests);
        }
        return Iterables.transform(newManifests, manifest -> GenericManifestFile.copyOf(manifest).withSnapshotId(this.snapshotId()).build());
    }

    private ManifestFile newFilesAsManifest() {
        if (this.hasNewFiles && this.cachedNewManifest != null) {
            this.deleteFile(this.cachedNewManifest.path());
            this.cachedNewManifest = null;
        }
        if (this.cachedNewManifest == null) {
            try {
                try (ManifestWriter<DataFile> writer = this.newManifestWriter(this.writeSpec());){
                    writer.addAll(this.newFiles);
                }
                this.cachedNewManifest = writer.toManifestFile();
                this.hasNewFiles = false;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to close manifest writer", new Object[0]);
            }
        }
        return this.cachedNewManifest;
    }

    private Iterable<ManifestFile> prepareDeleteManifests() {
        if (this.newDeleteFiles.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.of(this.newDeleteFilesAsManifest());
    }

    private ManifestFile newDeleteFilesAsManifest() {
        if (this.hasNewDeleteFiles && this.cachedNewDeleteManifest != null) {
            this.deleteFile(this.cachedNewDeleteManifest.path());
            this.cachedNewDeleteManifest = null;
        }
        if (this.cachedNewDeleteManifest == null) {
            try {
                try (ManifestWriter<DeleteFile> writer = this.newDeleteManifestWriter(this.writeSpec());){
                    writer.addAll(this.newDeleteFiles);
                }
                this.cachedNewDeleteManifest = writer.toManifestFile();
                this.hasNewDeleteFiles = false;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to close manifest writer", new Object[0]);
            }
        }
        return this.cachedNewDeleteManifest;
    }

    private class DeleteFileMergeManager
    extends ManifestMergeManager<DeleteFile> {
        DeleteFileMergeManager(long targetSizeBytes, int minCountToMerge, boolean mergeEnabled) {
            super(targetSizeBytes, minCountToMerge, mergeEnabled);
        }

        @Override
        protected long snapshotId() {
            return MergingSnapshotProducer.this.snapshotId();
        }

        @Override
        protected PartitionSpec spec(int specId) {
            return MergingSnapshotProducer.this.ops.current().spec(specId);
        }

        @Override
        protected void deleteFile(String location) {
            MergingSnapshotProducer.this.deleteFile(location);
        }

        @Override
        protected ManifestWriter<DeleteFile> newManifestWriter(PartitionSpec manifestSpec) {
            return MergingSnapshotProducer.this.newDeleteManifestWriter(manifestSpec);
        }

        @Override
        protected ManifestReader<DeleteFile> newManifestReader(ManifestFile manifest) {
            return MergingSnapshotProducer.this.newDeleteManifestReader(manifest);
        }
    }

    private class DeleteFileFilterManager
    extends ManifestFilterManager<DeleteFile> {
        private DeleteFileFilterManager() {
            super(MergingSnapshotProducer.this.ops.current().specsById());
        }

        @Override
        protected void deleteFile(String location) {
            MergingSnapshotProducer.this.deleteFile(location);
        }

        @Override
        protected ManifestWriter<DeleteFile> newManifestWriter(PartitionSpec manifestSpec) {
            return MergingSnapshotProducer.this.newDeleteManifestWriter(manifestSpec);
        }

        @Override
        protected ManifestReader<DeleteFile> newManifestReader(ManifestFile manifest) {
            return MergingSnapshotProducer.this.newDeleteManifestReader(manifest);
        }
    }

    private class DataFileMergeManager
    extends ManifestMergeManager<DataFile> {
        DataFileMergeManager(long targetSizeBytes, int minCountToMerge, boolean mergeEnabled) {
            super(targetSizeBytes, minCountToMerge, mergeEnabled);
        }

        @Override
        protected long snapshotId() {
            return MergingSnapshotProducer.this.snapshotId();
        }

        @Override
        protected PartitionSpec spec(int specId) {
            return MergingSnapshotProducer.this.ops.current().spec(specId);
        }

        @Override
        protected void deleteFile(String location) {
            MergingSnapshotProducer.this.deleteFile(location);
        }

        @Override
        protected ManifestWriter<DataFile> newManifestWriter(PartitionSpec manifestSpec) {
            return MergingSnapshotProducer.this.newManifestWriter(manifestSpec);
        }

        @Override
        protected ManifestReader<DataFile> newManifestReader(ManifestFile manifest) {
            return MergingSnapshotProducer.this.newManifestReader(manifest);
        }
    }

    private class DataFileFilterManager
    extends ManifestFilterManager<DataFile> {
        private DataFileFilterManager() {
            super(MergingSnapshotProducer.this.ops.current().specsById());
        }

        @Override
        protected void deleteFile(String location) {
            MergingSnapshotProducer.this.deleteFile(location);
        }

        @Override
        protected ManifestWriter<DataFile> newManifestWriter(PartitionSpec manifestSpec) {
            return MergingSnapshotProducer.this.newManifestWriter(manifestSpec);
        }

        @Override
        protected ManifestReader<DataFile> newManifestReader(ManifestFile manifest) {
            return MergingSnapshotProducer.this.newManifestReader(manifest);
        }
    }
}

