/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.threeten.extra;

import java.time.Duration;
import java.time.Period;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class AmountFormats {
    private static final int DAYS_PER_WEEK = 7;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int NANOS_PER_MILLIS = 1000000;
    private static final String BUNDLE_NAME = "org.apache.iceberg.shaded.org.threeten.extra.wordbased";
    private static final Pattern SPLITTER = Pattern.compile("[|][|][|]");
    private static final String WORDBASED_COMMASPACE = "WordBased.commaspace";
    private static final String WORDBASED_SPACEANDSPACE = "WordBased.spaceandspace";
    private static final String WORDBASED_YEAR = "WordBased.year";
    private static final String WORDBASED_MONTH = "WordBased.month";
    private static final String WORDBASED_WEEK = "WordBased.week";
    private static final String WORDBASED_DAY = "WordBased.day";
    private static final String WORDBASED_HOUR = "WordBased.hour";
    private static final String WORDBASED_MINUTE = "WordBased.minute";
    private static final String WORDBASED_SECOND = "WordBased.second";
    private static final String WORDBASED_MILLISECOND = "WordBased.millisecond";
    private static final IntPredicate PREDICATE_1 = value -> value == 1 || value == -1;
    private static final IntPredicate PREDICATE_END234_NOTTEENS = value -> {
        int abs = Math.abs(value);
        int last = abs % 10;
        int secondLast = abs % 100 / 10;
        return last >= 2 && last <= 4 && secondLast != 1;
    };

    public static String iso8601(Period period, Duration duration) {
        Objects.requireNonNull(period, "period must not be null");
        Objects.requireNonNull(duration, "duration must not be null");
        if (period.isZero()) {
            return duration.toString();
        }
        if (duration.isZero()) {
            return period.toString();
        }
        return period.toString() + duration.toString().substring(1);
    }

    public static String wordBased(Period period, Locale locale) {
        Objects.requireNonNull(period, "period must not be null");
        Objects.requireNonNull(locale, "locale must not be null");
        ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        UnitFormat[] formats = new UnitFormat[]{UnitFormat.of(bundle, WORDBASED_YEAR), UnitFormat.of(bundle, WORDBASED_MONTH), UnitFormat.of(bundle, WORDBASED_WEEK), UnitFormat.of(bundle, WORDBASED_DAY)};
        WordBased wb = new WordBased(formats, bundle.getString(WORDBASED_COMMASPACE), bundle.getString(WORDBASED_SPACEANDSPACE));
        Period normPeriod = period.normalized();
        int weeks = 0;
        int days = 0;
        if (normPeriod.getDays() % 7 == 0) {
            weeks = normPeriod.getDays() / 7;
        } else {
            days = normPeriod.getDays();
        }
        int[] values = new int[]{normPeriod.getYears(), normPeriod.getMonths(), weeks, days};
        return wb.format(values);
    }

    public static String wordBased(Duration duration, Locale locale) {
        Objects.requireNonNull(duration, "duration must not be null");
        Objects.requireNonNull(locale, "locale must not be null");
        ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        UnitFormat[] formats = new UnitFormat[]{UnitFormat.of(bundle, WORDBASED_HOUR), UnitFormat.of(bundle, WORDBASED_MINUTE), UnitFormat.of(bundle, WORDBASED_SECOND), UnitFormat.of(bundle, WORDBASED_MILLISECOND)};
        WordBased wb = new WordBased(formats, bundle.getString(WORDBASED_COMMASPACE), bundle.getString(WORDBASED_SPACEANDSPACE));
        long hours = duration.toHours();
        long mins = duration.toMinutes() % 60L;
        long secs = duration.getSeconds() % 60L;
        int millis = duration.getNano() / 1000000;
        int[] values = new int[]{(int)hours, (int)mins, (int)secs, millis};
        return wb.format(values);
    }

    public static String wordBased(Period period, Duration duration, Locale locale) {
        Objects.requireNonNull(period, "period must not be null");
        Objects.requireNonNull(duration, "duration must not be null");
        Objects.requireNonNull(locale, "locale must not be null");
        ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        UnitFormat[] formats = new UnitFormat[]{UnitFormat.of(bundle, WORDBASED_YEAR), UnitFormat.of(bundle, WORDBASED_MONTH), UnitFormat.of(bundle, WORDBASED_WEEK), UnitFormat.of(bundle, WORDBASED_DAY), UnitFormat.of(bundle, WORDBASED_HOUR), UnitFormat.of(bundle, WORDBASED_MINUTE), UnitFormat.of(bundle, WORDBASED_SECOND), UnitFormat.of(bundle, WORDBASED_MILLISECOND)};
        WordBased wb = new WordBased(formats, bundle.getString(WORDBASED_COMMASPACE), bundle.getString(WORDBASED_SPACEANDSPACE));
        Period normPeriod = period.normalized();
        int weeks = 0;
        int days = 0;
        if (normPeriod.getDays() % 7 == 0) {
            weeks = normPeriod.getDays() / 7;
        } else {
            days = normPeriod.getDays();
        }
        long totalHours = duration.toHours();
        int hours = (int)(totalHours % 24L);
        int mins = (int)(duration.toMinutes() % 60L);
        int secs = (int)(duration.getSeconds() % 60L);
        int millis = duration.getNano() / 1000000;
        int[] values = new int[]{normPeriod.getYears(), normPeriod.getMonths(), weeks, days += (int)(totalHours / 24L), hours, mins, secs, millis};
        return wb.format(values);
    }

    private AmountFormats() {
    }

    static final class PredicateFormat
    implements UnitFormat {
        private final IntPredicate[] predicates;
        private final String[] text;

        PredicateFormat(String[] predicateStrs, String[] text) {
            if (predicateStrs.length + 1 != text.length) {
                throw new IllegalStateException("Invalid word-based resource");
            }
            this.predicates = (IntPredicate[])Stream.of(predicateStrs).map(predicateStr -> this.findPredicate((String)predicateStr)).toArray(IntPredicate[]::new);
            this.text = text;
        }

        private IntPredicate findPredicate(String predicateStr) {
            switch (predicateStr) {
                case "One": {
                    return PREDICATE_1;
                }
                case "End234NotTeens": {
                    return PREDICATE_END234_NOTTEENS;
                }
            }
            throw new IllegalStateException("Invalid word-based resource");
        }

        @Override
        public void formatTo(int value, StringBuilder buf) {
            for (int i = 0; i < this.predicates.length; ++i) {
                if (!this.predicates[i].test(value)) continue;
                buf.append(value).append(this.text[i]);
                return;
            }
            buf.append(value).append(this.text[this.predicates.length]);
        }
    }

    static final class SinglePluralFormat
    implements UnitFormat {
        private final String single;
        private final String plural;

        SinglePluralFormat(String single, String plural) {
            this.single = single;
            this.plural = plural;
        }

        @Override
        public void formatTo(int value, StringBuilder buf) {
            buf.append(value).append(value == 1 || value == -1 ? this.single : this.plural);
        }
    }

    static interface UnitFormat {
        public static UnitFormat of(ResourceBundle bundle, String keyStem) {
            if (bundle.containsKey(keyStem + "s.predicates")) {
                String predicateList = bundle.getString(keyStem + "s.predicates");
                String textList = bundle.getString(keyStem + "s.list");
                String[] regexes = SPLITTER.split(predicateList);
                String[] text = SPLITTER.split(textList);
                return new PredicateFormat(regexes, text);
            }
            String single = bundle.getString(keyStem);
            String plural = bundle.getString(keyStem + "s");
            return new SinglePluralFormat(single, plural);
        }

        public void formatTo(int var1, StringBuilder var2);
    }

    static final class WordBased {
        private final UnitFormat[] units;
        private final String separator;
        private final String lastSeparator;

        public WordBased(UnitFormat[] units, String separator, String lastSeparator) {
            this.units = units;
            this.separator = separator;
            this.lastSeparator = lastSeparator;
        }

        String format(int[] values) {
            StringBuilder buf = new StringBuilder(32);
            int nonZeroCount = 0;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == 0) continue;
                ++nonZeroCount;
            }
            int count = 0;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == 0 && (count != 0 || i != values.length - 1)) continue;
                this.units[i].formatTo(values[i], buf);
                if (count < nonZeroCount - 2) {
                    buf.append(this.separator);
                } else if (count == nonZeroCount - 2) {
                    buf.append(this.lastSeparator);
                }
                ++count;
            }
            return buf.toString();
        }
    }
}

