/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.ParquetAvro;
import org.apache.iceberg.parquet.ParquetFilters;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.parquet.ParquetIterable;
import org.apache.iceberg.parquet.ParquetReadSupport;
import org.apache.iceberg.parquet.ParquetReader;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetValueWriters;
import org.apache.iceberg.parquet.ParquetWriteAdapter;
import org.apache.iceberg.parquet.ParquetWriteSupport;
import org.apache.iceberg.parquet.ParquetWriter;
import org.apache.iceberg.parquet.VectorizedParquetReader;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.org.apache.parquet.HadoopReadOptions;
import org.apache.iceberg.shaded.org.apache.parquet.ParquetReadOptions;
import org.apache.iceberg.shaded.org.apache.parquet.avro.AvroReadSupport;
import org.apache.iceberg.shaded.org.apache.parquet.avro.AvroWriteSupport;
import org.apache.iceberg.shaded.org.apache.parquet.column.ParquetProperties;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.ParquetReader;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.ParquetWriter;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.iceberg.shaded.org.apache.parquet.io.OutputFile;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.util.ArrayUtil;

public class Parquet {
    private static final Collection<String> READ_PROPERTIES_TO_REMOVE = Sets.newHashSet("parquet.read.filter", "parquet.private.read.filter.predicate", "parquet.read.support.class");

    private Parquet() {
    }

    public static WriteBuilder write(org.apache.iceberg.io.OutputFile file) {
        return new WriteBuilder(file);
    }

    public static DeleteWriteBuilder writeDeletes(org.apache.iceberg.io.OutputFile file) {
        return new DeleteWriteBuilder(file);
    }

    public static ReadBuilder read(InputFile file) {
        return new ReadBuilder(file);
    }

    public static void concat(Iterable<File> inputFiles, File outputFile, int rowGroupSize, Schema schema, Map<String, String> metadata) throws IOException {
        org.apache.iceberg.io.OutputFile file = Files.localOutput(outputFile);
        ParquetFileWriter writer = new ParquetFileWriter(ParquetIO.file(file), ParquetSchemaUtil.convert(schema, "table"), ParquetFileWriter.Mode.CREATE, (long)rowGroupSize, 0);
        writer.start();
        for (File inputFile : inputFiles) {
            writer.appendFile(ParquetIO.file(Files.localInput(inputFile)));
        }
        writer.end(metadata);
    }

    private static class ParquetReadBuilder<T>
    extends ParquetReader.Builder<T> {
        private Schema schema = null;
        private ReadSupport<T> readSupport = null;
        private boolean callInit = false;
        private NameMapping nameMapping = null;

        private ParquetReadBuilder(org.apache.iceberg.shaded.org.apache.parquet.io.InputFile file) {
            super(file);
        }

        public ParquetReadBuilder<T> project(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public ParquetReadBuilder<T> withNameMapping(NameMapping newNameMapping) {
            this.nameMapping = newNameMapping;
            return this;
        }

        public ParquetReadBuilder<T> readSupport(ReadSupport<T> newReadSupport) {
            this.readSupport = newReadSupport;
            return this;
        }

        public ParquetReadBuilder<T> callInit() {
            this.callInit = true;
            return this;
        }

        @Override
        protected ReadSupport<T> getReadSupport() {
            return new ParquetReadSupport<T>(this.schema, this.readSupport, this.callInit, this.nameMapping);
        }
    }

    public static class ReadBuilder {
        private final InputFile file;
        private final Map<String, String> properties = Maps.newHashMap();
        private Long start = null;
        private Long length = null;
        private Schema schema = null;
        private Expression filter = null;
        private ReadSupport<?> readSupport = null;
        private Function<MessageType, VectorizedReader<?>> batchedReaderFunc = null;
        private Function<MessageType, ParquetValueReader<?>> readerFunc = null;
        private boolean filterRecords = true;
        private boolean caseSensitive = true;
        private boolean callInit = false;
        private boolean reuseContainers = false;
        private int maxRecordsPerBatch = 10000;
        private NameMapping nameMapping = null;

        private ReadBuilder(InputFile file) {
            this.file = file;
        }

        public ReadBuilder split(long newStart, long newLength) {
            this.start = newStart;
            this.length = newLength;
            return this;
        }

        public ReadBuilder project(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public ReadBuilder caseInsensitive() {
            return this.caseSensitive(false);
        }

        public ReadBuilder caseSensitive(boolean newCaseSensitive) {
            this.caseSensitive = newCaseSensitive;
            return this;
        }

        public ReadBuilder filterRecords(boolean newFilterRecords) {
            this.filterRecords = newFilterRecords;
            return this;
        }

        public ReadBuilder filter(Expression newFilter) {
            this.filter = newFilter;
            return this;
        }

        public ReadBuilder readSupport(ReadSupport<?> newFilterSupport) {
            this.readSupport = newFilterSupport;
            return this;
        }

        public ReadBuilder createReaderFunc(Function<MessageType, ParquetValueReader<?>> newReaderFunction) {
            Preconditions.checkArgument(this.batchedReaderFunc == null, "Reader function cannot be set since the batched version is already set");
            this.readerFunc = newReaderFunction;
            return this;
        }

        public ReadBuilder createBatchedReaderFunc(Function<MessageType, VectorizedReader<?>> func) {
            Preconditions.checkArgument(this.readerFunc == null, "Batched reader function cannot be set since the non-batched version is already set");
            this.batchedReaderFunc = func;
            return this;
        }

        public ReadBuilder set(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public ReadBuilder callInit() {
            this.callInit = true;
            return this;
        }

        public ReadBuilder reuseContainers() {
            this.reuseContainers = true;
            return this;
        }

        public ReadBuilder recordsPerBatch(int numRowsPerBatch) {
            this.maxRecordsPerBatch = numRowsPerBatch;
            return this;
        }

        public ReadBuilder withNameMapping(NameMapping newNameMapping) {
            this.nameMapping = newNameMapping;
            return this;
        }

        public <D> CloseableIterable<D> build() {
            if (this.readerFunc != null || this.batchedReaderFunc != null) {
                ParquetReadOptions.Builder optionsBuilder;
                if (this.file instanceof HadoopInputFile) {
                    Configuration conf = new Configuration(((HadoopInputFile)this.file).getConf());
                    for (String property : READ_PROPERTIES_TO_REMOVE) {
                        conf.unset(property);
                    }
                    optionsBuilder = HadoopReadOptions.builder(conf);
                } else {
                    optionsBuilder = ParquetReadOptions.builder();
                }
                for (Map.Entry entry : this.properties.entrySet()) {
                    optionsBuilder.set((String)entry.getKey(), (String)entry.getValue());
                }
                if (this.start != null) {
                    optionsBuilder.withRange(this.start, this.start + this.length);
                }
                ParquetReadOptions options = optionsBuilder.build();
                if (this.batchedReaderFunc != null) {
                    return new VectorizedParquetReader(this.file, this.schema, options, this.batchedReaderFunc, this.nameMapping, this.filter, this.reuseContainers, this.caseSensitive, this.maxRecordsPerBatch);
                }
                return new ParquetReader(this.file, this.schema, options, this.readerFunc, this.nameMapping, this.filter, this.reuseContainers, this.caseSensitive);
            }
            ParquetReadBuilder<Object> builder = new ParquetReadBuilder<Object>(ParquetIO.file(this.file));
            builder.project(this.schema);
            if (this.readSupport != null) {
                builder.readSupport(this.readSupport);
            } else {
                builder.readSupport(new AvroReadSupport(ParquetAvro.DEFAULT_MODEL));
            }
            builder.set("parquet.strict.typing", "false").set("parquet.avro.compatible", "false").set("parquet.avro.add-list-element-records", "false");
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                builder.set(entry.getKey(), entry.getValue());
            }
            if (this.filter != null) {
                MessageType type;
                try (ParquetFileReader parquetFileReader = ParquetFileReader.open(ParquetIO.file(this.file));){
                    type = parquetFileReader.getFileMetaData().getSchema();
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException(iOException);
                }
                Schema schema = ParquetSchemaUtil.convert(type);
                builder.useStatsFilter().useDictionaryFilter().useRecordFilter(this.filterRecords).withFilter(ParquetFilters.convert(schema, this.filter, this.caseSensitive));
            } else {
                builder.useStatsFilter(false).useDictionaryFilter(false).useRecordFilter(false);
            }
            if (this.callInit) {
                builder.callInit();
            }
            if (this.start != null) {
                builder.withFileRange(this.start, this.start + this.length);
            }
            if (this.nameMapping != null) {
                builder.withNameMapping(this.nameMapping);
            }
            return new ParquetIterable(builder);
        }
    }

    private static class ParquetWriteBuilder<T>
    extends ParquetWriter.Builder<T, ParquetWriteBuilder<T>> {
        private Map<String, String> keyValueMetadata = Maps.newHashMap();
        private Map<String, String> config = Maps.newHashMap();
        private MessageType type;
        private WriteSupport<T> writeSupport;

        private ParquetWriteBuilder(OutputFile path) {
            super(path);
        }

        @Override
        protected ParquetWriteBuilder<T> self() {
            return this;
        }

        public ParquetWriteBuilder<T> setKeyValueMetadata(Map<String, String> keyValueMetadata) {
            this.keyValueMetadata = keyValueMetadata;
            return this.self();
        }

        public ParquetWriteBuilder<T> setConfig(Map<String, String> config) {
            this.config = config;
            return this.self();
        }

        public ParquetWriteBuilder<T> setType(MessageType type) {
            this.type = type;
            return this.self();
        }

        public ParquetWriteBuilder<T> setWriteSupport(WriteSupport<T> writeSupport) {
            this.writeSupport = writeSupport;
            return this.self();
        }

        @Override
        protected WriteSupport<T> getWriteSupport(Configuration configuration) {
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                configuration.set(entry.getKey(), entry.getValue());
            }
            return new ParquetWriteSupport<T>(this.type, this.keyValueMetadata, this.writeSupport);
        }
    }

    public static class DeleteWriteBuilder {
        private final WriteBuilder appenderBuilder;
        private final String location;
        private Function<MessageType, ParquetValueWriter<?>> createWriterFunc = null;
        private Schema rowSchema = null;
        private PartitionSpec spec = null;
        private StructLike partition = null;
        private EncryptionKeyMetadata keyMetadata = null;
        private int[] equalityFieldIds = null;
        private Function<CharSequence, ?> pathTransformFunc = Function.identity();

        private DeleteWriteBuilder(org.apache.iceberg.io.OutputFile file) {
            this.appenderBuilder = Parquet.write(file);
            this.location = file.location();
        }

        public DeleteWriteBuilder forTable(Table table) {
            this.rowSchema(table.schema());
            this.withSpec(table.spec());
            this.setAll(table.properties());
            this.metricsConfig(MetricsConfig.fromProperties(table.properties()));
            return this;
        }

        public DeleteWriteBuilder set(String property, String value) {
            this.appenderBuilder.set(property, value);
            return this;
        }

        public DeleteWriteBuilder setAll(Map<String, String> properties) {
            this.appenderBuilder.setAll(properties);
            return this;
        }

        public DeleteWriteBuilder meta(String property, String value) {
            this.appenderBuilder.meta(property, value);
            return this;
        }

        public DeleteWriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public DeleteWriteBuilder overwrite(boolean enabled) {
            this.appenderBuilder.overwrite(enabled);
            return this;
        }

        public DeleteWriteBuilder metricsConfig(MetricsConfig newMetricsConfig) {
            this.appenderBuilder.metricsConfig(newMetricsConfig);
            return this;
        }

        public DeleteWriteBuilder createWriterFunc(Function<MessageType, ParquetValueWriter<?>> newCreateWriterFunc) {
            this.createWriterFunc = newCreateWriterFunc;
            return this;
        }

        public DeleteWriteBuilder rowSchema(Schema newSchema) {
            this.rowSchema = newSchema;
            return this;
        }

        public DeleteWriteBuilder withSpec(PartitionSpec newSpec) {
            this.spec = newSpec;
            return this;
        }

        public DeleteWriteBuilder withPartition(StructLike key) {
            this.partition = key;
            return this;
        }

        public DeleteWriteBuilder withKeyMetadata(EncryptionKeyMetadata metadata) {
            this.keyMetadata = metadata;
            return this;
        }

        public DeleteWriteBuilder equalityFieldIds(List<Integer> fieldIds) {
            this.equalityFieldIds = ArrayUtil.toIntArray(fieldIds);
            return this;
        }

        public DeleteWriteBuilder equalityFieldIds(int ... fieldIds) {
            this.equalityFieldIds = fieldIds;
            return this;
        }

        public DeleteWriteBuilder transformPaths(Function<CharSequence, ?> newPathTransformFunc) {
            this.pathTransformFunc = newPathTransformFunc;
            return this;
        }

        public <T> EqualityDeleteWriter<T> buildEqualityWriter() throws IOException {
            Preconditions.checkState(this.rowSchema != null, "Cannot create equality delete file without a schema`");
            Preconditions.checkState(this.equalityFieldIds != null, "Cannot create equality delete file without delete field ids");
            Preconditions.checkState(this.createWriterFunc != null, "Cannot create equality delete file unless createWriterFunc is set");
            this.meta("delete-type", "equality");
            this.meta("delete-field-ids", IntStream.of(this.equalityFieldIds).mapToObj(Objects::toString).collect(Collectors.joining(", ")));
            this.appenderBuilder.schema(this.rowSchema);
            this.appenderBuilder.createWriterFunc(this.createWriterFunc);
            return new EqualityDeleteWriter(this.appenderBuilder.build(), FileFormat.PARQUET, this.location, this.spec, this.partition, this.keyMetadata, this.equalityFieldIds);
        }

        public <T> PositionDeleteWriter<T> buildPositionWriter() throws IOException {
            Preconditions.checkState(this.equalityFieldIds == null, "Cannot create position delete file using delete field ids");
            this.meta("delete-type", "position");
            if (this.rowSchema != null && this.createWriterFunc != null) {
                this.appenderBuilder.schema(DeleteSchemaUtil.posDeleteSchema(this.rowSchema));
                this.appenderBuilder.createWriterFunc(parquetSchema -> {
                    ParquetValueWriter<?> writer = this.createWriterFunc.apply((MessageType)parquetSchema);
                    if (writer instanceof ParquetValueWriters.StructWriter) {
                        return new ParquetValueWriters.PositionDeleteStructWriter((ParquetValueWriters.StructWriter)writer, this.pathTransformFunc);
                    }
                    throw new UnsupportedOperationException("Cannot wrap writer for position deletes: " + writer.getClass());
                });
            } else {
                this.appenderBuilder.schema(DeleteSchemaUtil.pathPosSchema());
                this.appenderBuilder.createWriterFunc(parquetSchema -> new ParquetValueWriters.PositionDeleteStructWriter((ParquetValueWriters.StructWriter)GenericParquetWriter.buildWriter(parquetSchema), Function.identity()));
            }
            return new PositionDeleteWriter(this.appenderBuilder.build(), FileFormat.PARQUET, this.location, this.spec, this.partition, this.keyMetadata);
        }
    }

    public static class WriteBuilder {
        private final org.apache.iceberg.io.OutputFile file;
        private final Map<String, String> metadata = Maps.newLinkedHashMap();
        private final Map<String, String> config = Maps.newLinkedHashMap();
        private Schema schema = null;
        private String name = "table";
        private WriteSupport<?> writeSupport = null;
        private Function<MessageType, ParquetValueWriter<?>> createWriterFunc = null;
        private MetricsConfig metricsConfig = MetricsConfig.getDefault();
        private ParquetFileWriter.Mode writeMode = ParquetFileWriter.Mode.CREATE;

        private WriteBuilder(org.apache.iceberg.io.OutputFile file) {
            this.file = file;
        }

        public WriteBuilder forTable(Table table) {
            this.schema(table.schema());
            this.setAll(table.properties());
            this.metricsConfig(MetricsConfig.fromProperties(table.properties()));
            return this;
        }

        public WriteBuilder schema(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public WriteBuilder named(String newName) {
            this.name = newName;
            return this;
        }

        public WriteBuilder writeSupport(WriteSupport<?> newWriteSupport) {
            this.writeSupport = newWriteSupport;
            return this;
        }

        public WriteBuilder set(String property, String value) {
            this.config.put(property, value);
            return this;
        }

        public WriteBuilder setAll(Map<String, String> properties) {
            this.config.putAll(properties);
            return this;
        }

        public WriteBuilder meta(String property, String value) {
            this.metadata.put(property, value);
            return this;
        }

        public WriteBuilder createWriterFunc(Function<MessageType, ParquetValueWriter<?>> newCreateWriterFunc) {
            this.createWriterFunc = newCreateWriterFunc;
            return this;
        }

        public WriteBuilder metricsConfig(MetricsConfig newMetricsConfig) {
            this.metricsConfig = newMetricsConfig;
            return this;
        }

        public WriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public WriteBuilder overwrite(boolean enabled) {
            this.writeMode = enabled ? ParquetFileWriter.Mode.OVERWRITE : ParquetFileWriter.Mode.CREATE;
            return this;
        }

        private <T> WriteSupport<T> getWriteSupport(MessageType type) {
            if (this.writeSupport != null) {
                return this.writeSupport;
            }
            return new AvroWriteSupport(type, ParquetAvro.parquetAvroSchema(AvroSchemaUtil.convert(this.schema, this.name)), ParquetAvro.DEFAULT_MODEL);
        }

        private CompressionCodecName codec() {
            String codec = this.config.getOrDefault("write.parquet.compression-codec", "gzip");
            try {
                return CompressionCodecName.valueOf(codec.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unsupported compression codec: " + codec);
            }
        }

        public <D> FileAppender<D> build() throws IOException {
            Preconditions.checkNotNull(this.schema, "Schema is required");
            Preconditions.checkNotNull(this.name, "Table name is required and cannot be null");
            this.meta("iceberg.schema", SchemaParser.toJson(this.schema));
            int rowGroupSize = Integer.parseInt(this.config.getOrDefault("write.parquet.row-group-size-bytes", "134217728"));
            int pageSize = Integer.parseInt(this.config.getOrDefault("write.parquet.page-size-bytes", "1048576"));
            int dictionaryPageSize = Integer.parseInt(this.config.getOrDefault("write.parquet.dict-size-bytes", "2097152"));
            String compressionLevel = this.config.getOrDefault("write.parquet.compression-level", TableProperties.PARQUET_COMPRESSION_LEVEL_DEFAULT);
            if (compressionLevel != null) {
                switch (this.codec()) {
                    case GZIP: {
                        this.config.put("zlib.compress.level", compressionLevel);
                        break;
                    }
                    case BROTLI: {
                        this.config.put("compression.brotli.quality", compressionLevel);
                        break;
                    }
                    case ZSTD: {
                        this.config.put("io.compression.codec.zstd.level", compressionLevel);
                        break;
                    }
                }
            }
            ParquetProperties.WriterVersion writerVersion = ParquetProperties.WriterVersion.PARQUET_1_0;
            this.set("parquet.avro.write-old-list-structure", "false");
            MessageType type = ParquetSchemaUtil.convert(this.schema, this.name);
            if (this.createWriterFunc != null) {
                Preconditions.checkArgument(this.writeSupport == null, "Cannot write with both write support and Parquet value writer");
                Configuration conf = this.file instanceof HadoopOutputFile ? ((HadoopOutputFile)this.file).getConf() : new Configuration();
                for (Map.Entry<String, String> entry : this.config.entrySet()) {
                    conf.set(entry.getKey(), entry.getValue());
                }
                ParquetProperties parquetProperties = ParquetProperties.builder().withWriterVersion(writerVersion).withPageSize(pageSize).withDictionaryPageSize(dictionaryPageSize).build();
                return new ParquetWriter(conf, this.file, this.schema, rowGroupSize, this.metadata, this.createWriterFunc, this.codec(), parquetProperties, this.metricsConfig, this.writeMode);
            }
            return new ParquetWriteAdapter(((ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)new ParquetWriteBuilder(ParquetIO.file(this.file)).withWriterVersion(writerVersion)).setType(type).setConfig(this.config).setKeyValueMetadata(this.metadata).setWriteSupport(this.getWriteSupport(type)).withCompressionCodec(this.codec())).withWriteMode(this.writeMode)).withRowGroupSize(rowGroupSize)).withPageSize(pageSize)).withDictionaryPageSize(dictionaryPageSize)).build(), this.metricsConfig);
        }
    }
}

