/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.hive.HiveIcebergInputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergMetaHook;
import org.apache.iceberg.mr.hive.HiveIcebergOutputCommitter;
import org.apache.iceberg.mr.hive.HiveIcebergOutputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergSerDe;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SerializationUtil;

public class HiveIcebergStorageHandler
implements HiveStoragePredicateHandler,
HiveStorageHandler {
    private static final String WRITE_KEY = "HiveIcebergStorageHandler_write";
    private Configuration conf;

    public Class<? extends InputFormat> getInputFormatClass() {
        return HiveIcebergInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HiveIcebergOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return HiveIcebergSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return new HiveIcebergMetaHook(this.conf);
    }

    public HiveAuthorizationProvider getAuthorizationProvider() {
        return null;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> map) {
        HiveIcebergStorageHandler.overlayTableProperties(this.conf, tableDesc, map);
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> map) {
        HiveIcebergStorageHandler.overlayTableProperties(this.conf, tableDesc, map);
        map.put(WRITE_KEY, "true");
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> map) {
    }

    public void configureInputJobCredentials(TableDesc tableDesc, Map<String, String> secrets) {
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        if (tableDesc != null && tableDesc.getJobProperties() != null && tableDesc.getJobProperties().get(WRITE_KEY) != null) {
            jobConf.set("mapred.output.committer.class", HiveIcebergOutputCommitter.class.getName());
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, Deserializer deserializer, ExprNodeDesc exprNodeDesc) {
        HiveStoragePredicateHandler.DecomposedPredicate predicate = new HiveStoragePredicateHandler.DecomposedPredicate();
        predicate.residualPredicate = (ExprNodeGenericFuncDesc)exprNodeDesc;
        predicate.pushedPredicate = (ExprNodeGenericFuncDesc)exprNodeDesc;
        return predicate;
    }

    public static FileIO io(Configuration config) {
        return (FileIO)SerializationUtil.deserializeFromBase64(config.get("iceberg.mr.file.io"));
    }

    public static LocationProvider location(Configuration config) {
        return (LocationProvider)SerializationUtil.deserializeFromBase64(config.get("iceberg.mr.location.provider"));
    }

    public static EncryptionManager encryption(Configuration config) {
        return (EncryptionManager)SerializationUtil.deserializeFromBase64(config.get("iceberg.mr.encription.manager"));
    }

    public static Schema schema(Configuration config) {
        return SchemaParser.fromJson(config.get("iceberg.mr.table.schema"));
    }

    public static PartitionSpec spec(Configuration config) {
        return PartitionSpecParser.fromJson(HiveIcebergStorageHandler.schema(config), config.get("iceberg.mr.table.partition.spec"));
    }

    @VisibleForTesting
    static void overlayTableProperties(Configuration configuration, TableDesc tableDesc, Map<String, String> map) {
        Properties props = tableDesc.getProperties();
        Table table = Catalogs.loadTable(configuration, props);
        String schemaJson = SchemaParser.toJson(table.schema());
        Maps.fromProperties(props).entrySet().stream().filter(entry -> !map.containsKey(entry.getKey())).forEach(entry -> map.put((String)entry.getKey(), (String)entry.getValue()));
        map.put("iceberg.mr.table.identifier", props.getProperty("name"));
        map.put("iceberg.mr.table.location", table.location());
        map.put("iceberg.mr.table.schema", schemaJson);
        map.put("iceberg.mr.table.partition.spec", PartitionSpecParser.toJson(table.spec()));
        String formatString = PropertyUtil.propertyAsString(table.properties(), "write.format.default", "parquet");
        map.put("iceberg.mr.write.file.format", formatString.toUpperCase(Locale.ENGLISH));
        map.put("iceberg.mr.write.target.file.size", table.properties().getOrDefault("write.target-file-size-bytes", String.valueOf(Long.MAX_VALUE)));
        if (table instanceof Serializable) {
            map.put("iceberg.mr.serialized.table", SerializationUtil.serializeToBase64(table));
        }
        map.put("iceberg.mr.file.io", SerializationUtil.serializeToBase64(table.io()));
        map.put("iceberg.mr.location.provider", SerializationUtil.serializeToBase64(table.locationProvider()));
        map.put("iceberg.mr.encription.manager", SerializationUtil.serializeToBase64(table.encryption()));
        map.remove("columns.comments");
        props.put("iceberg.mr.table.schema", schemaJson);
    }
}

