/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.util.Progressable;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.mr.hive.HiveIcebergRecordWriter;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandler;
import org.apache.iceberg.mr.mapred.Container;

public class HiveIcebergOutputFormat<T>
implements OutputFormat<NullWritable, Container<Record>>,
HiveOutputFormat<NullWritable, Container<Record>> {
    private static final String TASK_ATTEMPT_ID_KEY = "mapred.task.id";

    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class valueClass, boolean isCompressed, Properties tableAndSerDeProperties, Progressable progress) {
        return HiveIcebergOutputFormat.writer(jc);
    }

    public RecordWriter<NullWritable, Container<Record>> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) {
        return HiveIcebergOutputFormat.writer(job);
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) {
    }

    private static HiveIcebergRecordWriter writer(JobConf jc) {
        TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)jc.get(TASK_ATTEMPT_ID_KEY));
        Schema schema = HiveIcebergStorageHandler.schema((Configuration)jc);
        PartitionSpec spec = HiveIcebergStorageHandler.spec((Configuration)jc);
        FileFormat fileFormat = FileFormat.valueOf(jc.get("iceberg.mr.write.file.format"));
        long targetFileSize = jc.getLong("iceberg.mr.write.target.file.size", Long.MAX_VALUE);
        FileIO io = HiveIcebergStorageHandler.io((Configuration)jc);
        LocationProvider location = HiveIcebergStorageHandler.location((Configuration)jc);
        EncryptionManager encryption = HiveIcebergStorageHandler.encryption((Configuration)jc);
        OutputFileFactory outputFileFactory = new OutputFileFactory(spec, fileFormat, location, io, encryption, taskAttemptID.getTaskID().getId(), taskAttemptID.getId(), jc.get(HiveConf.ConfVars.HIVEQUERYID.varname) + "-" + taskAttemptID.getJobID());
        HiveIcebergRecordWriter writer = new HiveIcebergRecordWriter(schema, spec, fileFormat, new GenericAppenderFactory(schema, spec), outputFileFactory, io, targetFileSize, taskAttemptID);
        return writer;
    }
}

