/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.mr.hive.HiveIcebergFilterFactory;
import org.apache.iceberg.mr.hive.HiveIcebergSplit;
import org.apache.iceberg.mr.mapred.Container;
import org.apache.iceberg.mr.mapred.MapredIcebergInputFormat;
import org.apache.iceberg.mr.mapreduce.IcebergSplit;
import org.apache.iceberg.util.SerializationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIcebergInputFormat
extends MapredIcebergInputFormat<Record>
implements CombineHiveInputFormat.AvoidSplitCombination {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergInputFormat.class);

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        String hiveFilter = job.get("hive.io.filter.expr.serialized");
        if (hiveFilter != null) {
            ExprNodeGenericFuncDesc exprNodeDesc = (ExprNodeGenericFuncDesc)SerializationUtilities.deserializeObject((String)hiveFilter, ExprNodeGenericFuncDesc.class);
            SearchArgument sarg = ConvertAstToSearchArg.create((Configuration)job, (ExprNodeGenericFuncDesc)exprNodeDesc);
            try {
                Expression filter = HiveIcebergFilterFactory.generateFilterExpression(sarg);
                job.set("iceberg.mr.filter.expression", SerializationUtil.serializeToBase64(filter));
            }
            catch (UnsupportedOperationException e) {
                LOG.warn("Unable to create Iceberg filter, continuing without filter (will be applied by Hive later): ", (Throwable)e);
            }
        }
        String[] selectedColumns = ColumnProjectionUtils.getReadColumnNames((Configuration)job);
        job.setStrings("iceberg.mr.selected.columns", selectedColumns);
        String location = job.get("iceberg.mr.table.location");
        return (InputSplit[])Arrays.stream(super.getSplits(job, numSplits)).map(split -> new HiveIcebergSplit((IcebergSplit)split, location)).toArray(InputSplit[]::new);
    }

    @Override
    public RecordReader<Void, Container<Record>> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        String[] selectedColumns = ColumnProjectionUtils.getReadColumnNames((Configuration)job);
        job.setStrings("iceberg.mr.selected.columns", selectedColumns);
        return super.getRecordReader(split, job, reporter);
    }

    public boolean shouldSkipCombine(Path path, Configuration conf) {
        return true;
    }
}

