/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;

public class JsonUtil {
    private static final JsonFactory FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);

    private JsonUtil() {
    }

    public static JsonFactory factory() {
        return FACTORY;
    }

    public static ObjectMapper mapper() {
        return MAPPER;
    }

    public static int getInt(String property, JsonNode node) {
        Preconditions.checkArgument(node.has(property), "Cannot parse missing int %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isNumber(), "Cannot parse %s from non-numeric value: %s", (Object)property, (Object)pNode);
        return pNode.asInt();
    }

    public static Integer getIntOrNull(String property, JsonNode node) {
        if (!node.has(property)) {
            return null;
        }
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isIntegralNumber() && pNode.canConvertToInt(), "Cannot parse %s from non-string value: %s", (Object)property, (Object)pNode);
        return pNode.asInt();
    }

    public static long getLong(String property, JsonNode node) {
        Preconditions.checkArgument(node.has(property), "Cannot parse missing long %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isNumber(), "Cannot parse %s from non-numeric value: %s", (Object)property, (Object)pNode);
        return pNode.asLong();
    }

    public static boolean getBool(String property, JsonNode node) {
        Preconditions.checkArgument(node.has(property), "Cannot parse missing boolean %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isBoolean(), "Cannot parse %s from non-boolean value: %s", (Object)property, (Object)pNode);
        return pNode.asBoolean();
    }

    public static String getString(String property, JsonNode node) {
        Preconditions.checkArgument(node.has(property), "Cannot parse missing string %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isTextual(), "Cannot parse %s from non-string value: %s", (Object)property, (Object)pNode);
        return pNode.asText();
    }

    public static String getStringOrNull(String property, JsonNode node) {
        if (!node.has(property)) {
            return null;
        }
        JsonNode pNode = node.get(property);
        if (pNode != null && pNode.isNull()) {
            return null;
        }
        Preconditions.checkArgument(pNode != null && pNode.isTextual(), "Cannot parse %s from non-string value: %s", (Object)property, (Object)pNode);
        return pNode.asText();
    }

    public static Map<String, String> getStringMap(String property, JsonNode node) {
        Preconditions.checkArgument(node.has(property), "Cannot parse missing map %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isObject(), "Cannot parse %s from non-object value: %s", (Object)property, (Object)pNode);
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        Iterator<String> fields = pNode.fieldNames();
        while (fields.hasNext()) {
            String field = fields.next();
            builder.put(field, JsonUtil.getString(field, pNode));
        }
        return builder.build();
    }

    public static List<String> getStringList(String property, JsonNode node) {
        Preconditions.checkArgument(node.has(property), "Cannot parse missing list %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isArray(), "Cannot parse %s from non-array value: %s", (Object)property, (Object)pNode);
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator<JsonNode> elements = pNode.elements();
        while (elements.hasNext()) {
            JsonNode element = elements.next();
            Preconditions.checkArgument(element.isTextual(), "Cannot parse string from non-text value: %s", (Object)element);
            builder.add(element.asText());
        }
        return builder.build();
    }
}

