/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.column;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.shaded.org.apache.parquet.column.Encoding;

public class EncodingStats {
    final Map<Encoding, Integer> dictStats;
    final Map<Encoding, Integer> dataStats;
    private final boolean usesV2Pages;

    private EncodingStats(Map<Encoding, Integer> dictStats, Map<Encoding, Integer> dataStats, boolean usesV2Pages) {
        this.dictStats = dictStats;
        this.dataStats = dataStats;
        this.usesV2Pages = usesV2Pages;
    }

    public Set<Encoding> getDictionaryEncodings() {
        return this.dictStats.keySet();
    }

    public Set<Encoding> getDataEncodings() {
        return this.dataStats.keySet();
    }

    public int getNumDictionaryPagesEncodedAs(Encoding enc) {
        if (this.dictStats.containsKey((Object)enc)) {
            return this.dictStats.get((Object)enc);
        }
        return 0;
    }

    public int getNumDataPagesEncodedAs(Encoding enc) {
        if (this.dataStats.containsKey((Object)enc)) {
            return this.dataStats.get((Object)enc);
        }
        return 0;
    }

    public boolean hasDictionaryPages() {
        return !this.dictStats.isEmpty();
    }

    public boolean hasDictionaryEncodedPages() {
        Set<Encoding> encodings = this.dataStats.keySet();
        return encodings.contains((Object)Encoding.RLE_DICTIONARY) || encodings.contains((Object)Encoding.PLAIN_DICTIONARY);
    }

    public boolean hasNonDictionaryEncodedPages() {
        if (this.dataStats.isEmpty()) {
            return false;
        }
        HashSet<Encoding> encodings = new HashSet<Encoding>(this.dataStats.keySet());
        if (!encodings.remove((Object)Encoding.RLE_DICTIONARY) && !encodings.remove((Object)Encoding.PLAIN_DICTIONARY)) {
            return true;
        }
        return !encodings.isEmpty();
    }

    public boolean usesV2Pages() {
        return this.usesV2Pages;
    }

    public static class Builder {
        private final Map<Encoding, Integer> dictStats = new LinkedHashMap<Encoding, Integer>();
        private final Map<Encoding, Integer> dataStats = new LinkedHashMap<Encoding, Integer>();
        private boolean usesV2Pages = false;

        public Builder clear() {
            this.usesV2Pages = false;
            this.dictStats.clear();
            this.dataStats.clear();
            return this;
        }

        public Builder withV2Pages() {
            this.usesV2Pages = true;
            return this;
        }

        public Builder addDictEncoding(Encoding encoding) {
            return this.addDictEncoding(encoding, 1);
        }

        public Builder addDictEncoding(Encoding encoding, int numPages) {
            Integer pages = this.dictStats.get((Object)encoding);
            this.dictStats.put(encoding, numPages + (pages != null ? pages : 0));
            return this;
        }

        public Builder addDataEncodings(Collection<Encoding> encodings) {
            for (Encoding encoding : encodings) {
                this.addDataEncoding(encoding);
            }
            return this;
        }

        public Builder addDataEncoding(Encoding encoding) {
            return this.addDataEncoding(encoding, 1);
        }

        public Builder addDataEncoding(Encoding encoding, int numPages) {
            Integer pages = this.dataStats.get((Object)encoding);
            this.dataStats.put(encoding, numPages + (pages != null ? pages : 0));
            return this;
        }

        public EncodingStats build() {
            return new EncodingStats(Collections.unmodifiableMap(new LinkedHashMap<Encoding, Integer>(this.dictStats)), Collections.unmodifiableMap(new LinkedHashMap<Encoding, Integer>(this.dataStats)), this.usesV2Pages);
        }
    }
}

