/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.Function;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.Binary;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.types.Type;

class ParquetConversions {
    private ParquetConversions() {
    }

    static <T> Literal<T> fromParquetPrimitive(Type type, PrimitiveType parquetType, Object value) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return Literal.of((Boolean)value);
            }
            case INTEGER: 
            case DATE: {
                return Literal.of((Integer)value);
            }
            case LONG: 
            case TIME: 
            case TIMESTAMP: {
                return Literal.of((Long)value);
            }
            case FLOAT: {
                return Literal.of(((Float)value).floatValue());
            }
            case DOUBLE: {
                return Literal.of((Double)value);
            }
            case STRING: {
                Function<Object, Object> stringConversion = ParquetConversions.converterFromParquet(parquetType);
                return Literal.of((CharSequence)stringConversion.apply(value));
            }
            case UUID: {
                Function<Object, Object> uuidConversion = ParquetConversions.converterFromParquet(parquetType);
                return Literal.of((UUID)uuidConversion.apply(value));
            }
            case FIXED: 
            case BINARY: {
                Function<Object, Object> binaryConversion = ParquetConversions.converterFromParquet(parquetType);
                return Literal.of((ByteBuffer)binaryConversion.apply(value));
            }
            case DECIMAL: {
                Function<Object, Object> decimalConversion = ParquetConversions.converterFromParquet(parquetType);
                return Literal.of((BigDecimal)decimalConversion.apply(value));
            }
        }
        throw new IllegalArgumentException("Unsupported primitive type: " + type);
    }

    static Function<Object, Object> converterFromParquet(PrimitiveType type) {
        if (type.getOriginalType() != null) {
            switch (type.getOriginalType()) {
                case UTF8: {
                    return binary -> StandardCharsets.UTF_8.decode(((Binary)binary).toByteBuffer());
                }
                case DECIMAL: {
                    int scale = type.getDecimalMetadata().getScale();
                    switch (type.getPrimitiveTypeName()) {
                        case INT32: 
                        case INT64: {
                            return num -> BigDecimal.valueOf(((Number)num).longValue(), scale);
                        }
                        case FIXED_LEN_BYTE_ARRAY: 
                        case BINARY: {
                            return bin -> new BigDecimal(new BigInteger(((Binary)bin).getBytes()), scale);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported primitive type for decimal: " + (Object)((Object)type.getPrimitiveTypeName()));
                }
            }
        }
        switch (type.getPrimitiveTypeName()) {
            case FIXED_LEN_BYTE_ARRAY: 
            case BINARY: {
                return binary -> ByteBuffer.wrap(((Binary)binary).getBytes());
            }
        }
        return obj -> obj;
    }
}

