/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFile;

public class OutputFileFactory {
    private final PartitionSpec spec;
    private final FileFormat format;
    private final LocationProvider locations;
    private final FileIO io;
    private final EncryptionManager encryptionManager;
    private final int partitionId;
    private final long taskId;
    private final String operationId;
    private final AtomicInteger fileCount = new AtomicInteger(0);

    public OutputFileFactory(PartitionSpec spec, FileFormat format, LocationProvider locations, FileIO io, EncryptionManager encryptionManager, int partitionId, long taskId) {
        this(spec, format, locations, io, encryptionManager, partitionId, taskId, UUID.randomUUID().toString());
    }

    public OutputFileFactory(PartitionSpec spec, FileFormat format, LocationProvider locations, FileIO io, EncryptionManager encryptionManager, int partitionId, long taskId, String operationId) {
        this.spec = spec;
        this.format = format;
        this.locations = locations;
        this.io = io;
        this.encryptionManager = encryptionManager;
        this.partitionId = partitionId;
        this.taskId = taskId;
        this.operationId = operationId;
    }

    private String generateFilename() {
        return this.format.addExtension(String.format("%05d-%d-%s-%05d", this.partitionId, this.taskId, this.operationId, this.fileCount.incrementAndGet()));
    }

    public EncryptedOutputFile newOutputFile() {
        OutputFile file = this.io.newOutputFile(this.locations.newDataLocation(this.generateFilename()));
        return this.encryptionManager.encrypt(file);
    }

    public EncryptedOutputFile newOutputFile(PartitionKey key) {
        String newDataLocation = this.locations.newDataLocation(this.spec, key, this.generateFilename());
        OutputFile rawOutputFile = this.io.newOutputFile(newDataLocation);
        return this.encryptionManager.encrypt(rawOutputFile);
    }
}

