/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.GenericDataFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;

public class DataFilesTable
extends BaseMetadataTable {
    private final TableOperations ops;
    private final Table table;
    private final String name;

    DataFilesTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".files");
    }

    DataFilesTable(TableOperations ops, Table table, String name) {
        this.ops = ops;
        this.table = table;
        this.name = name;
    }

    @Override
    Table table() {
        return this.table;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TableScan newScan() {
        return new FilesTableScan(this.ops, this.table, this.schema());
    }

    @Override
    public Schema schema() {
        Schema schema = new Schema(DataFile.getType(this.table.spec().partitionType()).fields());
        if (this.table.spec().fields().size() < 1) {
            return TypeUtil.selectNot(schema, Sets.newHashSet(102));
        }
        return schema;
    }

    @Override
    String metadataLocation() {
        return this.ops.current().metadataFileLocation();
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.FILES;
    }

    static class ManifestReadTask
    extends BaseFileScanTask
    implements DataTask {
        private final FileIO io;
        private final ManifestFile manifest;
        private final Schema schema;

        ManifestReadTask(FileIO io, ManifestFile manifest, Schema schema, String schemaString, String specString, ResidualEvaluator residuals) {
            super(DataFiles.fromManifest(manifest), null, schemaString, specString, residuals);
            this.io = io;
            this.manifest = manifest;
            this.schema = schema;
        }

        @Override
        public CloseableIterable<StructLike> rows() {
            return CloseableIterable.transform(ManifestFiles.read(this.manifest, this.io).project(this.schema), file -> (GenericDataFile)file);
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of(this);
        }
    }

    public static class FilesTableScan
    extends BaseTableScan {
        private final Schema fileSchema;

        FilesTableScan(TableOperations ops, Table table, Schema fileSchema) {
            super(ops, table, fileSchema);
            this.fileSchema = fileSchema;
        }

        private FilesTableScan(TableOperations ops, Table table, Schema schema, Schema fileSchema, TableScanContext context) {
            super(ops, table, schema, context);
            this.fileSchema = fileSchema;
        }

        @Override
        protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            return new FilesTableScan(ops, table, schema, this.fileSchema, context);
        }

        @Override
        protected long targetSplitSize(TableOperations ops) {
            return ops.current().propertyAsLong("read.split.metadata-target-size", 0x2000000L);
        }

        @Override
        protected CloseableIterable<FileScanTask> planFiles(TableOperations ops, Snapshot snapshot, Expression rowFilter, boolean ignoreResiduals, boolean caseSensitive, boolean colStats) {
            CloseableIterable<ManifestFile> manifests = CloseableIterable.withNoopClose(snapshot.dataManifests());
            String schemaString = SchemaParser.toJson(this.schema());
            String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
            Expression filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
            ResidualEvaluator residuals = ResidualEvaluator.unpartitioned(filter);
            return CloseableIterable.transform(manifests, manifest -> new ManifestReadTask(ops.io(), (ManifestFile)manifest, this.fileSchema, schemaString, specString, residuals));
        }
    }
}

