/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.BaseOverwriteFiles;
import org.apache.iceberg.BaseReplacePartitions;
import org.apache.iceberg.BaseReplaceSortOrder;
import org.apache.iceberg.BaseRewriteFiles;
import org.apache.iceberg.BaseRewriteManifests;
import org.apache.iceberg.BaseRowDelta;
import org.apache.iceberg.BaseUpdatePartitionSpec;
import org.apache.iceberg.DataTableScan;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.FastAppend;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.MergeAppend;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PropertiesUpdate;
import org.apache.iceberg.RemoveSnapshots;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.Rollback;
import org.apache.iceberg.RollbackToSnapshot;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaUpdate;
import org.apache.iceberg.SetLocation;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotManager;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StaticTableOperations;
import org.apache.iceberg.StreamingDelete;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;

public class BaseTable
implements Table,
HasTableOperations,
Serializable {
    private final TableOperations ops;
    private final String name;

    public BaseTable(TableOperations ops, String name) {
        this.ops = ops;
        this.name = name;
    }

    @Override
    public TableOperations operations() {
        return this.ops;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void refresh() {
        this.ops.refresh();
    }

    @Override
    public TableScan newScan() {
        return new DataTableScan(this.ops, this);
    }

    @Override
    public Schema schema() {
        return this.ops.current().schema();
    }

    @Override
    public PartitionSpec spec() {
        return this.ops.current().spec();
    }

    @Override
    public Map<Integer, PartitionSpec> specs() {
        return this.ops.current().specsById();
    }

    @Override
    public SortOrder sortOrder() {
        return this.ops.current().sortOrder();
    }

    @Override
    public Map<Integer, SortOrder> sortOrders() {
        return this.ops.current().sortOrdersById();
    }

    @Override
    public Map<String, String> properties() {
        return this.ops.current().properties();
    }

    @Override
    public String location() {
        return this.ops.current().location();
    }

    @Override
    public Snapshot currentSnapshot() {
        return this.ops.current().currentSnapshot();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.ops.current().snapshot(snapshotId);
    }

    @Override
    public Iterable<Snapshot> snapshots() {
        return this.ops.current().snapshots();
    }

    @Override
    public List<HistoryEntry> history() {
        return this.ops.current().snapshotLog();
    }

    @Override
    public UpdateSchema updateSchema() {
        return new SchemaUpdate(this.ops);
    }

    @Override
    public UpdatePartitionSpec updateSpec() {
        return new BaseUpdatePartitionSpec(this.ops);
    }

    @Override
    public UpdateProperties updateProperties() {
        return new PropertiesUpdate(this.ops);
    }

    @Override
    public ReplaceSortOrder replaceSortOrder() {
        return new BaseReplaceSortOrder(this.ops);
    }

    @Override
    public UpdateLocation updateLocation() {
        return new SetLocation(this.ops);
    }

    @Override
    public AppendFiles newAppend() {
        return new MergeAppend(this.name, this.ops);
    }

    @Override
    public AppendFiles newFastAppend() {
        return new FastAppend(this.name, this.ops);
    }

    @Override
    public RewriteFiles newRewrite() {
        return new BaseRewriteFiles(this.name, this.ops);
    }

    @Override
    public RewriteManifests rewriteManifests() {
        return new BaseRewriteManifests(this.ops);
    }

    @Override
    public OverwriteFiles newOverwrite() {
        return new BaseOverwriteFiles(this.name, this.ops);
    }

    @Override
    public RowDelta newRowDelta() {
        return new BaseRowDelta(this.name, this.ops);
    }

    @Override
    public ReplacePartitions newReplacePartitions() {
        return new BaseReplacePartitions(this.name, this.ops);
    }

    @Override
    public DeleteFiles newDelete() {
        return new StreamingDelete(this.name, this.ops);
    }

    @Override
    public ExpireSnapshots expireSnapshots() {
        return new RemoveSnapshots(this.ops);
    }

    @Override
    public Rollback rollback() {
        return new RollbackToSnapshot(this.name, this.ops);
    }

    @Override
    public ManageSnapshots manageSnapshots() {
        return new SnapshotManager(this.name, this.ops);
    }

    @Override
    public Transaction newTransaction() {
        return Transactions.newTransaction(this.name, this.ops);
    }

    @Override
    public FileIO io() {
        return this.operations().io();
    }

    @Override
    public EncryptionManager encryption() {
        return this.operations().encryption();
    }

    @Override
    public LocationProvider locationProvider() {
        return this.operations().locationProvider();
    }

    public String toString() {
        return this.name();
    }

    Object writeReplace() {
        return new TableProxy(this);
    }

    private static class TableProxy
    implements Serializable {
        private FileIO io;
        private String name;
        private String metadataLocation;

        private TableProxy(BaseTable table) {
            this.io = table.io();
            this.name = table.name();
            this.metadataLocation = table.operations().current().metadataFileLocation();
        }

        private Object readResolve() {
            return new BaseTable(new StaticTableOperations(this.metadataLocation, this.io), this.name);
        }
    }
}

