/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMetastoreCatalog
implements Catalog {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMetastoreCatalog.class);

    @Override
    public Table createTable(TableIdentifier identifier, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        return this.buildTable(identifier, schema).withPartitionSpec(spec).withLocation(location).withProperties(properties).create();
    }

    @Override
    public Transaction newCreateTableTransaction(TableIdentifier identifier, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        return this.buildTable(identifier, schema).withPartitionSpec(spec).withLocation(location).withProperties(properties).createTransaction();
    }

    @Override
    public Transaction newReplaceTableTransaction(TableIdentifier identifier, Schema schema, PartitionSpec spec, String location, Map<String, String> properties, boolean orCreate) {
        Catalog.TableBuilder tableBuilder = this.buildTable(identifier, schema).withPartitionSpec(spec).withLocation(location).withProperties(properties);
        if (orCreate) {
            return tableBuilder.createOrReplaceTransaction();
        }
        return tableBuilder.replaceTransaction();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Table loadTable(TableIdentifier identifier) {
        Table result;
        if (this.isValidIdentifier(identifier)) {
            TableOperations ops = this.newTableOps(identifier);
            if (ops.current() == null) {
                if (!this.isValidMetadataIdentifier(identifier)) throw new NoSuchTableException("Table does not exist: %s", identifier);
                result = this.loadMetadataTable(identifier);
            } else {
                result = new BaseTable(ops, BaseMetastoreCatalog.fullTableName(this.name(), identifier));
            }
        } else {
            if (!this.isValidMetadataIdentifier(identifier)) throw new NoSuchTableException("Invalid table identifier: %s", identifier);
            result = this.loadMetadataTable(identifier);
        }
        LOG.info("Table loaded by catalog: {}", (Object)result);
        return result;
    }

    @Override
    public Catalog.TableBuilder buildTable(TableIdentifier identifier, Schema schema) {
        return new BaseMetastoreCatalogTableBuilder(identifier, schema);
    }

    private Table loadMetadataTable(TableIdentifier identifier) {
        String tableName = identifier.name();
        MetadataTableType type = MetadataTableType.from(tableName);
        if (type != null) {
            TableIdentifier baseTableIdentifier = TableIdentifier.of(identifier.namespace().levels());
            TableOperations ops = this.newTableOps(baseTableIdentifier);
            if (ops.current() == null) {
                throw new NoSuchTableException("Table does not exist: %s", baseTableIdentifier);
            }
            return MetadataTableUtils.createMetadataTableInstance(ops, this.name(), baseTableIdentifier, identifier, type);
        }
        throw new NoSuchTableException("Table does not exist: %s", identifier);
    }

    private boolean isValidMetadataIdentifier(TableIdentifier identifier) {
        return MetadataTableType.from(identifier.name()) != null && this.isValidIdentifier(TableIdentifier.of(identifier.namespace().levels()));
    }

    protected boolean isValidIdentifier(TableIdentifier tableIdentifier) {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.name() + ")";
    }

    protected abstract TableOperations newTableOps(TableIdentifier var1);

    protected abstract String defaultWarehouseLocation(TableIdentifier var1);

    protected static String fullTableName(String catalogName, TableIdentifier identifier) {
        StringBuilder sb = new StringBuilder();
        if (catalogName.contains("/") || catalogName.contains(":")) {
            sb.append(catalogName);
            if (!catalogName.endsWith("/")) {
                sb.append("/");
            }
        } else {
            sb.append(catalogName).append(".");
        }
        for (String level : identifier.namespace().levels()) {
            sb.append(level).append(".");
        }
        sb.append(identifier.name());
        return sb.toString();
    }

    protected class BaseMetastoreCatalogTableBuilder
    implements Catalog.TableBuilder {
        private final TableIdentifier identifier;
        private final Schema schema;
        private final ImmutableMap.Builder<String, String> propertiesBuilder = ImmutableMap.builder();
        private PartitionSpec spec = PartitionSpec.unpartitioned();
        private SortOrder sortOrder = SortOrder.unsorted();
        private String location = null;

        public BaseMetastoreCatalogTableBuilder(TableIdentifier identifier, Schema schema) {
            Preconditions.checkArgument(BaseMetastoreCatalog.this.isValidIdentifier(identifier), "Invalid table identifier: %s", (Object)identifier);
            this.identifier = identifier;
            this.schema = schema;
        }

        @Override
        public Catalog.TableBuilder withPartitionSpec(PartitionSpec newSpec) {
            this.spec = newSpec != null ? newSpec : PartitionSpec.unpartitioned();
            return this;
        }

        @Override
        public Catalog.TableBuilder withSortOrder(SortOrder newSortOrder) {
            this.sortOrder = newSortOrder != null ? newSortOrder : SortOrder.unsorted();
            return this;
        }

        @Override
        public Catalog.TableBuilder withLocation(String newLocation) {
            this.location = newLocation;
            return this;
        }

        @Override
        public Catalog.TableBuilder withProperties(Map<String, String> properties) {
            if (properties != null) {
                this.propertiesBuilder.putAll(properties);
            }
            return this;
        }

        @Override
        public Catalog.TableBuilder withProperty(String key, String value) {
            this.propertiesBuilder.put(key, value);
            return this;
        }

        @Override
        public Table create() {
            TableOperations ops = BaseMetastoreCatalog.this.newTableOps(this.identifier);
            if (ops.current() != null) {
                throw new AlreadyExistsException("Table already exists: %s", this.identifier);
            }
            String baseLocation = this.location != null ? this.location : BaseMetastoreCatalog.this.defaultWarehouseLocation(this.identifier);
            ImmutableMap<String, String> properties = this.propertiesBuilder.build();
            TableMetadata metadata = TableMetadata.newTableMetadata(this.schema, this.spec, this.sortOrder, baseLocation, properties);
            try {
                ops.commit(null, metadata);
            }
            catch (CommitFailedException ignored) {
                throw new AlreadyExistsException("Table was created concurrently: %s", this.identifier);
            }
            return new BaseTable(ops, BaseMetastoreCatalog.fullTableName(BaseMetastoreCatalog.this.name(), this.identifier));
        }

        @Override
        public Transaction createTransaction() {
            TableOperations ops = BaseMetastoreCatalog.this.newTableOps(this.identifier);
            if (ops.current() != null) {
                throw new AlreadyExistsException("Table already exists: %s", this.identifier);
            }
            String baseLocation = this.location != null ? this.location : BaseMetastoreCatalog.this.defaultWarehouseLocation(this.identifier);
            ImmutableMap<String, String> properties = this.propertiesBuilder.build();
            TableMetadata metadata = TableMetadata.newTableMetadata(this.schema, this.spec, this.sortOrder, baseLocation, properties);
            return Transactions.createTableTransaction(this.identifier.toString(), ops, metadata);
        }

        @Override
        public Transaction replaceTransaction() {
            return this.newReplaceTableTransaction(false);
        }

        @Override
        public Transaction createOrReplaceTransaction() {
            return this.newReplaceTableTransaction(true);
        }

        private Transaction newReplaceTableTransaction(boolean orCreate) {
            TableMetadata metadata;
            TableOperations ops = BaseMetastoreCatalog.this.newTableOps(this.identifier);
            if (!orCreate && ops.current() == null) {
                throw new NoSuchTableException("No such table: %s", this.identifier);
            }
            if (ops.current() != null) {
                String baseLocation = this.location != null ? this.location : ops.current().location();
                metadata = ops.current().buildReplacement(this.schema, this.spec, this.sortOrder, baseLocation, this.propertiesBuilder.build());
            } else {
                String baseLocation = this.location != null ? this.location : BaseMetastoreCatalog.this.defaultWarehouseLocation(this.identifier);
                metadata = TableMetadata.newTableMetadata(this.schema, this.spec, this.sortOrder, baseLocation, this.propertiesBuilder.build());
            }
            if (orCreate) {
                return Transactions.createOrReplaceTableTransaction(this.identifier.toString(), ops, metadata);
            }
            return Transactions.replaceTableTransaction(this.identifier.toString(), ops, metadata);
        }
    }
}

