/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.function.Consumer;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.iceberg.shaded.com.google.protobuf25.CodedInputStream;
import org.apache.iceberg.shaded.org.apache.orc.CompressionCodec;
import org.apache.iceberg.shaded.org.apache.orc.EncryptionAlgorithm;
import org.apache.iceberg.shaded.org.apache.orc.impl.CryptoUtils;
import org.apache.iceberg.shaded.org.apache.orc.impl.OrcCodecPool;
import org.apache.iceberg.shaded.org.apache.orc.impl.OutStream;
import org.apache.iceberg.shaded.org.apache.orc.impl.PositionProvider;
import org.apache.iceberg.shaded.org.apache.orc.storage.common.io.DiskRangeList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(InStream.class);
    public static final int PROTOBUF_MESSAGE_MAX_LIMIT = 0x40000000;
    protected final Object name;
    protected final long offset;
    protected final long length;
    protected DiskRangeList bytes;
    protected long position;

    public InStream(Object name, long offset, long length) {
        this.name = name;
        this.offset = offset;
        this.length = length;
    }

    public String toString() {
        return this.name.toString();
    }

    @Override
    public abstract void close();

    protected abstract void setCurrent(DiskRangeList var1, boolean var2);

    protected void reset(DiskRangeList input) {
        this.bytes = input;
        while (input != null && (input.getEnd() <= this.offset || input.getOffset() > this.offset + this.length)) {
            input = input.next;
        }
        this.position = input == null || input.getOffset() <= this.offset ? 0L : input.getOffset() - this.offset;
        this.setCurrent(input, true);
    }

    public abstract void changeIv(Consumer<byte[]> var1);

    static int getRangeNumber(DiskRangeList list, DiskRangeList current) {
        int result = 0;
        DiskRangeList range = list;
        while (range != null && range != current) {
            ++result;
            range = range.next;
        }
        return result;
    }

    private static ByteBuffer allocateBuffer(int size, boolean isDirect) {
        if (isDirect) {
            return ByteBuffer.allocateDirect(size);
        }
        return ByteBuffer.allocate(size);
    }

    public abstract void seek(PositionProvider var1) throws IOException;

    public static StreamOptions options() {
        return new StreamOptions();
    }

    public static InStream create(Object name, DiskRangeList input, long offset, long length, StreamOptions options) {
        LOG.debug("Reading {} with {} from {} for {}", new Object[]{name, options, offset, length});
        if (options == null || options.codec == null) {
            if (options == null || options.key == null) {
                return new UncompressedStream(name, input, offset, length);
            }
            OutStream.logKeyAndIv(name, options.getKey(), options.getIv());
            return new EncryptedStream(name, input, offset, length, options);
        }
        if (options.key == null) {
            return new CompressedStream(name, input, offset, length, options);
        }
        OutStream.logKeyAndIv(name, options.getKey(), options.getIv());
        return new EncryptedCompressedStream(name, input, offset, length, options);
    }

    public static InStream create(Object name, DiskRangeList input, long offset, long length) {
        return InStream.create(name, input, offset, length, null);
    }

    public static CodedInputStream createCodedInputStream(InStream inStream) {
        CodedInputStream codedInputStream = CodedInputStream.newInstance(inStream);
        codedInputStream.setSizeLimit(0x40000000);
        return codedInputStream;
    }

    public static class StreamOptions
    implements Cloneable {
        private CompressionCodec codec;
        private int bufferSize;
        private EncryptionAlgorithm algorithm;
        private Key key;
        private byte[] iv;

        public StreamOptions(StreamOptions other) {
            this.codec = other.codec;
            this.bufferSize = other.bufferSize;
            this.algorithm = other.algorithm;
            this.key = other.key;
            this.iv = other.iv == null ? null : (byte[])other.iv.clone();
        }

        public StreamOptions() {
        }

        public StreamOptions withCodec(CompressionCodec value) {
            this.codec = value;
            return this;
        }

        public StreamOptions withBufferSize(int value) {
            this.bufferSize = value;
            return this;
        }

        public StreamOptions withEncryption(EncryptionAlgorithm algorithm, Key key, byte[] iv) {
            this.algorithm = algorithm;
            this.key = key;
            this.iv = iv;
            return this;
        }

        public boolean isCompressed() {
            return this.codec != null;
        }

        public CompressionCodec getCodec() {
            return this.codec;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public EncryptionAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        public Key getKey() {
            return this.key;
        }

        public byte[] getIv() {
            return this.iv;
        }

        public StreamOptions clone() {
            try {
                StreamOptions clone = (StreamOptions)super.clone();
                if (clone.codec != null) {
                    clone.codec = OrcCodecPool.getCodec(this.codec.getKind());
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new UnsupportedOperationException("uncloneable", e);
            }
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("compress: ");
            buffer.append(this.codec == null ? "none" : this.codec.getKind());
            buffer.append(", buffer size: ");
            buffer.append(this.bufferSize);
            if (this.key != null) {
                buffer.append(", encryption: ");
                buffer.append((Object)this.algorithm);
            }
            return buffer.toString();
        }
    }

    private static class EncryptedCompressedStream
    extends CompressedStream {
        private final EncryptionState encrypt;

        public EncryptedCompressedStream(Object name, DiskRangeList input, long offset, long length, StreamOptions options) {
            super(name, offset, length, options);
            this.encrypt = new EncryptionState(name, offset, options);
            this.reset(input);
        }

        @Override
        protected void setCurrent(DiskRangeList newRange, boolean isJump) {
            this.currentRange = newRange;
            if (newRange != null) {
                long rangeOffset = newRange.getOffset();
                int ignoreBytes = 0;
                ByteBuffer encrypted = newRange.getData().slice();
                if (rangeOffset < this.offset) {
                    ignoreBytes = (int)(this.offset - rangeOffset);
                    encrypted.position(ignoreBytes);
                }
                if (isJump) {
                    this.encrypt.changeIv((long)ignoreBytes + rangeOffset - this.offset);
                }
                encrypted.limit(ignoreBytes + (int)Math.min((long)encrypted.remaining(), this.length));
                this.compressed = this.encrypt.decrypt(encrypted);
                if (this.position + this.offset > rangeOffset + (long)ignoreBytes) {
                    this.compressed.position((int)(this.position + this.offset - rangeOffset - (long)ignoreBytes));
                }
            }
        }

        @Override
        public void close() {
            super.close();
            this.encrypt.close();
        }

        @Override
        public void changeIv(Consumer<byte[]> modifier) {
            this.encrypt.changeIv(modifier);
        }

        @Override
        public String toString() {
            return "encrypted " + super.toString();
        }
    }

    private static class CompressedStream
    extends InStream {
        private final int bufferSize;
        private ByteBuffer uncompressed;
        private final CompressionCodec codec;
        protected ByteBuffer compressed;
        protected DiskRangeList currentRange;
        private boolean isUncompressedOriginal;

        public CompressedStream(Object name, long offset, long length, StreamOptions options) {
            super(name, offset, length);
            this.codec = options.codec;
            this.bufferSize = options.bufferSize;
        }

        public CompressedStream(Object name, DiskRangeList input, long offset, long length, StreamOptions options) {
            super(name, offset, length);
            this.codec = options.codec;
            this.bufferSize = options.bufferSize;
            this.reset(input);
        }

        private void allocateForUncompressed(int size, boolean isDirect) {
            this.uncompressed = InStream.allocateBuffer(size, isDirect);
        }

        @Override
        protected void setCurrent(DiskRangeList newRange, boolean isJump) {
            this.currentRange = newRange;
            if (newRange != null) {
                this.compressed = newRange.getData().slice();
                int pos = (int)(this.position + this.offset - newRange.getOffset());
                this.compressed.position(pos);
                this.compressed.limit(pos + (int)Math.min((long)this.compressed.remaining(), this.length - this.position));
            }
        }

        private int readHeaderByte() {
            while (this.currentRange != null && (this.compressed == null || this.compressed.remaining() <= 0)) {
                this.setCurrent(this.currentRange.next, false);
            }
            if (this.compressed != null && this.compressed.remaining() > 0) {
                ++this.position;
                return this.compressed.get() & 0xFF;
            }
            throw new IllegalStateException("Can't read header at " + this);
        }

        private void readHeader() throws IOException {
            int b0 = this.readHeaderByte();
            int b1 = this.readHeaderByte();
            int b2 = this.readHeaderByte();
            boolean isOriginal = (b0 & 1) == 1;
            int chunkLength = b2 << 15 | b1 << 7 | b0 >> 1;
            if (chunkLength > this.bufferSize) {
                throw new IllegalArgumentException("Buffer size too small. size = " + this.bufferSize + " needed = " + chunkLength + " in " + this.name);
            }
            ByteBuffer slice = this.slice(chunkLength);
            if (isOriginal) {
                this.uncompressed = slice;
                this.isUncompressedOriginal = true;
            } else {
                if (this.isUncompressedOriginal) {
                    this.allocateForUncompressed(this.bufferSize, slice.isDirect());
                    this.isUncompressedOriginal = false;
                } else if (this.uncompressed == null) {
                    this.allocateForUncompressed(this.bufferSize, slice.isDirect());
                } else {
                    this.uncompressed.clear();
                }
                this.codec.decompress(slice, this.uncompressed);
            }
        }

        @Override
        public int read() throws IOException {
            if (!this.ensureUncompressed()) {
                return -1;
            }
            return 0xFF & this.uncompressed.get();
        }

        @Override
        public int read(byte[] data, int offset, int length) throws IOException {
            if (!this.ensureUncompressed()) {
                return -1;
            }
            int actualLength = Math.min(length, this.uncompressed.remaining());
            this.uncompressed.get(data, offset, actualLength);
            return actualLength;
        }

        private boolean ensureUncompressed() throws IOException {
            while (this.uncompressed == null || this.uncompressed.remaining() == 0) {
                if (this.position == this.length) {
                    return false;
                }
                this.readHeader();
            }
            return true;
        }

        @Override
        public int available() throws IOException {
            if (!this.ensureUncompressed()) {
                return 0;
            }
            return this.uncompressed.remaining();
        }

        @Override
        public void close() {
            this.uncompressed = null;
            this.compressed = null;
            this.currentRange = null;
            this.position = this.length;
            this.bytes = null;
        }

        @Override
        public void changeIv(Consumer<byte[]> modifier) {
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            this.seek(index.getNext());
            long uncompressedBytes = index.getNext();
            if (uncompressedBytes != 0L) {
                this.readHeader();
                this.uncompressed.position(this.uncompressed.position() + (int)uncompressedBytes);
            } else if (this.uncompressed != null) {
                this.uncompressed.position(this.uncompressed.limit());
            }
        }

        private ByteBuffer slice(int chunkLength) throws IOException {
            int len = chunkLength;
            DiskRangeList oldRange = this.currentRange;
            long oldPosition = this.position;
            if (this.compressed.remaining() >= len) {
                ByteBuffer slice = this.compressed.slice();
                slice.limit(len);
                this.position += (long)len;
                this.compressed.position(this.compressed.position() + len);
                return slice;
            }
            if (this.currentRange.next == null) {
                throw new IOException("EOF in " + this + " while trying to read " + chunkLength + " bytes");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Crossing into next BufferChunk because compressed only has %d bytes (needs %d)", this.compressed.remaining(), len));
            }
            ByteBuffer copy = InStream.allocateBuffer(chunkLength, this.compressed.isDirect());
            this.position += (long)this.compressed.remaining();
            len -= this.compressed.remaining();
            copy.put(this.compressed);
            while (this.currentRange.next != null) {
                this.setCurrent(this.currentRange.next, false);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Read slow-path, >1 cross block reads with %s", this.toString()));
                }
                if (this.compressed.remaining() >= len) {
                    ByteBuffer slice = this.compressed.slice();
                    slice.limit(len);
                    copy.put(slice);
                    this.position += (long)len;
                    this.compressed.position(this.compressed.position() + len);
                    copy.flip();
                    return copy;
                }
                this.position += (long)this.compressed.remaining();
                len -= this.compressed.remaining();
                copy.put(this.compressed);
            }
            this.position = oldPosition;
            this.setCurrent(oldRange, true);
            throw new IOException("EOF in " + this + " while trying to read " + chunkLength + " bytes");
        }

        void seek(long desired) throws IOException {
            if (desired == 0L && this.bytes == null) {
                return;
            }
            long posn = desired + this.offset;
            DiskRangeList range = this.bytes;
            while (range != null) {
                if (range.getOffset() <= posn && (range.next == null ? posn <= range.getEnd() : posn < range.getEnd())) {
                    this.position = desired;
                    this.setCurrent(range, true);
                    return;
                }
                range = range.next;
            }
            throw new IOException("Seek outside of data in " + this + " to " + desired);
        }

        private String rangeString() {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            DiskRangeList range = this.bytes;
            while (range != null) {
                if (i != 0) {
                    builder.append("; ");
                }
                builder.append(" range ");
                builder.append(i);
                builder.append(" = ");
                builder.append(range.getOffset());
                builder.append(" to ");
                builder.append(range.getEnd());
                ++i;
                range = range.next;
            }
            return builder.toString();
        }

        @Override
        public String toString() {
            return "compressed stream " + this.name + " position: " + this.position + " length: " + this.length + " range: " + CompressedStream.getRangeNumber(this.bytes, this.currentRange) + " offset: " + (this.compressed == null ? 0 : this.compressed.position()) + " limit: " + (this.compressed == null ? 0 : this.compressed.limit()) + this.rangeString() + (this.uncompressed == null ? "" : " uncompressed: " + this.uncompressed.position() + " to " + this.uncompressed.limit());
        }
    }

    public static class EncryptedStream
    extends UncompressedStream {
        private final EncryptionState encrypt;

        public EncryptedStream(Object name, DiskRangeList input, long offset, long length, StreamOptions options) {
            super(name, offset, length);
            this.encrypt = new EncryptionState(name, offset, options);
            this.reset(input);
        }

        @Override
        protected void setCurrent(DiskRangeList newRange, boolean isJump) {
            this.currentRange = newRange;
            if (newRange != null) {
                this.currentOffset = newRange.getOffset();
                ByteBuffer encrypted = newRange.getData().slice();
                if (this.currentOffset < this.offset) {
                    int ignoreBytes = (int)(this.offset - this.currentOffset);
                    encrypted.position(ignoreBytes);
                    this.currentOffset = this.offset;
                }
                if (isJump) {
                    this.encrypt.changeIv(this.currentOffset - this.offset);
                }
                if ((long)encrypted.remaining() > this.length + this.offset - this.currentOffset) {
                    encrypted.limit((int)(this.length + this.offset - this.currentOffset));
                }
                this.decrypted = this.encrypt.decrypt(encrypted);
                this.decrypted.position((int)(this.position + this.offset - this.currentOffset));
            }
        }

        @Override
        public void close() {
            super.close();
            this.encrypt.close();
        }

        @Override
        public void changeIv(Consumer<byte[]> modifier) {
            this.encrypt.changeIv(modifier);
        }

        @Override
        public String toString() {
            return "encrypted " + super.toString();
        }
    }

    static class EncryptionState {
        private final Object name;
        private final Key key;
        private final byte[] iv;
        private final Cipher cipher;
        private final long offset;
        private ByteBuffer decrypted;

        EncryptionState(Object name, long offset, StreamOptions options) {
            this.name = name;
            this.offset = offset;
            EncryptionAlgorithm algorithm = options.getAlgorithm();
            this.key = options.getKey();
            this.iv = options.getIv();
            this.cipher = algorithm.createCipher();
        }

        void changeIv(Consumer<byte[]> modifier) {
            modifier.accept(this.iv);
            this.updateIv();
            OutStream.logKeyAndIv(this.name, this.key, this.iv);
        }

        private void updateIv() {
            try {
                this.cipher.init(2, this.key, new IvParameterSpec(this.iv));
            }
            catch (InvalidKeyException e) {
                throw new IllegalArgumentException("Invalid key on " + this.name, e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new IllegalArgumentException("Invalid iv on " + this.name, e);
            }
        }

        void changeIv(long offset) {
            int blockSize = this.cipher.getBlockSize();
            long encryptionBlocks = offset / (long)blockSize;
            long extra = offset % (long)blockSize;
            CryptoUtils.clearCounter(this.iv);
            if (encryptionBlocks != 0L) {
                int posn = this.iv.length - 1;
                while (encryptionBlocks > 0L) {
                    long sum = (long)(this.iv[posn] & 0xFF) + encryptionBlocks;
                    this.iv[posn--] = (byte)sum;
                    encryptionBlocks = sum / 256L;
                }
            }
            this.updateIv();
            if (extra > 0L) {
                try {
                    byte[] wasted = new byte[(int)extra];
                    this.cipher.update(wasted, 0, wasted.length, wasted, 0);
                }
                catch (ShortBufferException e) {
                    throw new IllegalArgumentException("Short buffer in " + this.name, e);
                }
            }
        }

        ByteBuffer decrypt(ByteBuffer encrypted) {
            int length = encrypted.remaining();
            if (this.decrypted == null || this.decrypted.capacity() < length) {
                this.decrypted = ByteBuffer.allocate(length);
            } else {
                this.decrypted.clear();
            }
            try {
                int output = this.cipher.update(encrypted, this.decrypted);
                if (output != length) {
                    throw new IllegalArgumentException("Problem decrypting " + this.name + " at " + this.offset);
                }
            }
            catch (ShortBufferException e) {
                throw new IllegalArgumentException("Problem decrypting " + this.name + " at " + this.offset, e);
            }
            this.decrypted.flip();
            return this.decrypted;
        }

        void close() {
            this.decrypted = null;
        }
    }

    public static class UncompressedStream
    extends InStream {
        protected ByteBuffer decrypted;
        protected DiskRangeList currentRange;
        protected long currentOffset;

        public UncompressedStream(Object name, long offset, long length) {
            super(name, offset, length);
        }

        public UncompressedStream(Object name, DiskRangeList input, long offset, long length) {
            super(name, offset, length);
            this.reset(input);
        }

        @Override
        public int read() {
            if (this.decrypted == null || this.decrypted.remaining() == 0) {
                if (this.position == this.length) {
                    return -1;
                }
                this.setCurrent(this.currentRange.next, false);
            }
            ++this.position;
            return 0xFF & this.decrypted.get();
        }

        @Override
        protected void setCurrent(DiskRangeList newRange, boolean isJump) {
            this.currentRange = newRange;
            if (newRange != null) {
                this.decrypted = newRange.getData().slice();
                this.currentOffset = newRange.getOffset();
                int start = (int)(this.position + this.offset - this.currentOffset);
                this.decrypted.position(start);
                this.decrypted.limit(start + (int)Math.min((long)this.decrypted.remaining(), this.length - this.position));
            }
        }

        @Override
        public int read(byte[] data, int offset, int length) {
            if (this.decrypted == null || this.decrypted.remaining() == 0) {
                if (this.position == this.length) {
                    return -1;
                }
                this.setCurrent(this.currentRange.next, false);
            }
            int actualLength = Math.min(length, this.decrypted.remaining());
            this.decrypted.get(data, offset, actualLength);
            this.position += (long)actualLength;
            return actualLength;
        }

        @Override
        public int available() {
            if (this.decrypted != null && this.decrypted.remaining() > 0) {
                return this.decrypted.remaining();
            }
            return (int)(this.length - this.position);
        }

        @Override
        public void close() {
            this.currentRange = null;
            this.position = this.length;
            this.decrypted = null;
            this.bytes = null;
        }

        @Override
        public void changeIv(Consumer<byte[]> modifier) {
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            this.seek(index.getNext());
        }

        public void seek(long desired) throws IOException {
            if (desired == 0L && this.bytes == null) {
                return;
            }
            long positionFile = desired + this.offset;
            if (this.currentRange == null || positionFile < this.currentRange.getOffset() || positionFile >= this.currentRange.getEnd()) {
                DiskRangeList curRange = this.bytes;
                while (curRange != null) {
                    if (curRange.getOffset() <= positionFile && (curRange.next == null ? positionFile <= curRange.getEnd() : positionFile < curRange.getEnd())) {
                        this.position = desired;
                        this.setCurrent(curRange, true);
                        return;
                    }
                    curRange = curRange.next;
                }
                throw new IllegalArgumentException("Seek in " + this.name + " to " + desired + " is outside of the data");
            }
            this.decrypted.position((int)(positionFile - this.currentOffset));
            this.position = desired;
        }

        @Override
        public String toString() {
            return "uncompressed stream " + this.name + " position: " + this.position + " length: " + this.length + " range: " + UncompressedStream.getRangeNumber(this.bytes, this.currentRange) + " offset: " + this.currentRange.getOffset() + " position: " + (this.decrypted == null ? 0 : this.decrypted.position()) + " limit: " + (this.decrypted == null ? 0 : this.decrypted.limit());
        }
    }
}

