/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public abstract class IcebergTimestampObjectInspectorHive3
extends AbstractPrimitiveJavaObjectInspector
implements TimestampObjectInspector {
    private static final IcebergTimestampObjectInspectorHive3 INSTANCE_WITH_ZONE = new IcebergTimestampObjectInspectorHive3(){

        @Override
        LocalDateTime toLocalDateTime(Object o) {
            return ((OffsetDateTime)o).toLocalDateTime();
        }
    };
    private static final IcebergTimestampObjectInspectorHive3 INSTANCE_WITHOUT_ZONE = new IcebergTimestampObjectInspectorHive3(){

        @Override
        LocalDateTime toLocalDateTime(Object o) {
            return (LocalDateTime)o;
        }
    };

    public static IcebergTimestampObjectInspectorHive3 get(boolean adjustToUTC) {
        return adjustToUTC ? INSTANCE_WITH_ZONE : INSTANCE_WITHOUT_ZONE;
    }

    private IcebergTimestampObjectInspectorHive3() {
        super(TypeInfoFactory.timestampTypeInfo);
    }

    abstract LocalDateTime toLocalDateTime(Object var1);

    public Timestamp getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        LocalDateTime time = this.toLocalDateTime(o);
        Timestamp timestamp = Timestamp.ofEpochMilli((long)time.toInstant(ZoneOffset.UTC).toEpochMilli());
        timestamp.setNanos(time.getNano());
        return timestamp;
    }

    public TimestampWritableV2 getPrimitiveWritableObject(Object o) {
        Timestamp ts = this.getPrimitiveJavaObject(o);
        return ts == null ? null : new TimestampWritableV2(ts);
    }

    public Object copyObject(Object o) {
        if (o == null) {
            return null;
        }
        Timestamp ts = (Timestamp)o;
        Timestamp copy = new Timestamp(ts);
        copy.setNanos(ts.getNanos());
        return copy;
    }
}

