/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public abstract class IcebergTimestampObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements TimestampObjectInspector {
    private static final IcebergTimestampObjectInspector INSTANCE_WITH_ZONE = new IcebergTimestampObjectInspector(){

        @Override
        LocalDateTime toLocalDateTime(Object o) {
            return ((OffsetDateTime)o).toLocalDateTime();
        }
    };
    private static final IcebergTimestampObjectInspector INSTANCE_WITHOUT_ZONE = new IcebergTimestampObjectInspector(){

        @Override
        LocalDateTime toLocalDateTime(Object o) {
            return (LocalDateTime)o;
        }
    };

    public static IcebergTimestampObjectInspector get(boolean adjustToUTC) {
        return adjustToUTC ? INSTANCE_WITH_ZONE : INSTANCE_WITHOUT_ZONE;
    }

    private IcebergTimestampObjectInspector() {
        super(TypeInfoFactory.timestampTypeInfo);
    }

    abstract LocalDateTime toLocalDateTime(Object var1);

    public Timestamp getPrimitiveJavaObject(Object o) {
        return o == null ? null : Timestamp.valueOf(this.toLocalDateTime(o));
    }

    public TimestampWritable getPrimitiveWritableObject(Object o) {
        Timestamp ts = this.getPrimitiveJavaObject(o);
        return ts == null ? null : new TimestampWritable(ts);
    }

    public Object copyObject(Object o) {
        if (o == null) {
            return null;
        }
        Timestamp ts = (Timestamp)o;
        Timestamp copy = new Timestamp(ts.getTime());
        copy.setNanos(ts.getNanos());
        return copy;
    }
}

