/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.iceberg.util.ByteBuffers;

public abstract class IcebergBinaryObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements BinaryObjectInspector {
    private static final IcebergBinaryObjectInspector BYTE_ARRAY = new IcebergBinaryObjectInspector(){

        @Override
        byte[] toByteArray(Object o) {
            return (byte[])o;
        }
    };
    private static final IcebergBinaryObjectInspector BYTE_BUFFER = new IcebergBinaryObjectInspector(){

        @Override
        byte[] toByteArray(Object o) {
            return ByteBuffers.toByteArray((ByteBuffer)o);
        }
    };

    public static IcebergBinaryObjectInspector byteArray() {
        return BYTE_ARRAY;
    }

    public static IcebergBinaryObjectInspector byteBuffer() {
        return BYTE_BUFFER;
    }

    private IcebergBinaryObjectInspector() {
        super(TypeInfoFactory.binaryTypeInfo);
    }

    abstract byte[] toByteArray(Object var1);

    public byte[] getPrimitiveJavaObject(Object o) {
        return this.toByteArray(o);
    }

    public BytesWritable getPrimitiveWritableObject(Object o) {
        return o == null ? null : new BytesWritable(this.getPrimitiveJavaObject(o));
    }

    public Object copyObject(Object o) {
        if (o == null) {
            return null;
        }
        byte[] bytes = (byte[])o;
        return Arrays.copyOf(bytes, bytes.length);
    }
}

