/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.hive.HiveIcebergInputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergMetaHook;
import org.apache.iceberg.mr.hive.HiveIcebergOutputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergSerDe;

public class HiveIcebergStorageHandler
implements HiveStoragePredicateHandler,
HiveStorageHandler {
    private Configuration conf;

    public Class<? extends InputFormat> getInputFormatClass() {
        return HiveIcebergInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HiveIcebergOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return HiveIcebergSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return new HiveIcebergMetaHook(this.conf);
    }

    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return null;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> map) {
        Properties props = tableDesc.getProperties();
        Table table = Catalogs.loadTable(this.conf, props);
        map.put("iceberg.mr.table.identifier", props.getProperty("name"));
        map.put("iceberg.mr.table.location", table.location());
        map.put("iceberg.mr.table.schema", SchemaParser.toJson(table.schema()));
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> map) {
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> map) {
    }

    public void configureInputJobCredentials(TableDesc tableDesc, Map<String, String> secrets) {
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, Deserializer deserializer, ExprNodeDesc exprNodeDesc) {
        HiveStoragePredicateHandler.DecomposedPredicate predicate = new HiveStoragePredicateHandler.DecomposedPredicate();
        predicate.residualPredicate = (ExprNodeGenericFuncDesc)exprNodeDesc;
        predicate.pushedPredicate = (ExprNodeGenericFuncDesc)exprNodeDesc;
        return predicate;
    }
}

