/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.hive.serde.objectinspector.IcebergObjectInspector;
import org.apache.iceberg.mr.mapred.Container;

public class HiveIcebergSerDe
extends AbstractSerDe {
    private ObjectInspector inspector;

    public void initialize(@Nullable Configuration configuration, Properties serDeProperties) throws SerDeException {
        Schema tableSchema;
        if (configuration.get("iceberg.mr.table.schema") != null) {
            tableSchema = SchemaParser.fromJson(configuration.get("iceberg.mr.table.schema"));
        } else if (serDeProperties.get("iceberg.mr.table.schema") != null) {
            tableSchema = SchemaParser.fromJson((String)serDeProperties.get("iceberg.mr.table.schema"));
        } else {
            try {
                tableSchema = Catalogs.loadTable(configuration, serDeProperties).schema();
            }
            catch (NoSuchTableException nte) {
                throw new SerDeException("Please provide an existing table or a valid schema", (Throwable)nte);
            }
        }
        try {
            this.inspector = IcebergObjectInspector.create(tableSchema);
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
    }

    public Class<? extends Writable> getSerializedClass() {
        return Container.class;
    }

    public Writable serialize(Object o, ObjectInspector objectInspector) {
        throw new UnsupportedOperationException("Serialization is not supported.");
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public Object deserialize(Writable writable) {
        return ((Container)writable).get();
    }

    public ObjectInspector getObjectInspector() {
        return this.inspector;
    }
}

