/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIcebergMetaHook
implements HiveMetaHook {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergMetaHook.class);
    private static final Set<String> PARAMETERS_TO_REMOVE = ImmutableSet.of("iceberg.mr.table.schema", "iceberg.mr.table.partition.spec", "location", "name");
    private static final Set<String> PROPERTIES_TO_REMOVE = ImmutableSet.of("external.table.purge", "storage_handler", "EXTERNAL", "bucketing_version");
    private final Configuration conf;
    private Table icebergTable = null;
    private Properties catalogProperties;
    private boolean deleteIcebergTable;
    private FileIO deleteIo;
    private TableMetadata deleteMetadata;

    public HiveIcebergMetaHook(Configuration conf) {
        this.conf = conf;
    }

    public void preCreateTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        this.catalogProperties = this.getCatalogProperties(hmsTable);
        hmsTable.getParameters().put("table_type", "iceberg".toUpperCase());
        if (!Catalogs.hiveCatalog(this.conf)) {
            try {
                this.icebergTable = Catalogs.loadTable(this.conf, this.catalogProperties);
                Preconditions.checkArgument(this.catalogProperties.getProperty("iceberg.mr.table.schema") == null, "Iceberg table already created - can not use provided schema");
                Preconditions.checkArgument(this.catalogProperties.getProperty("iceberg.mr.table.partition.spec") == null, "Iceberg table already created - can not use provided partition specification");
                LOG.info("Iceberg table already exists {}", (Object)this.icebergTable);
                return;
            }
            catch (NoSuchTableException noSuchTableException) {
                // empty catch block
            }
        }
        String schemaString = this.catalogProperties.getProperty("iceberg.mr.table.schema");
        Preconditions.checkNotNull(schemaString, "Please provide a table schema");
        Schema schema = SchemaParser.fromJson(schemaString);
        String specString = this.catalogProperties.getProperty("iceberg.mr.table.partition.spec");
        if (specString != null) {
            PartitionSpecParser.fromJson(schema, specString);
        }
        if (hmsTable.getParameters().get("external.table.purge") == null) {
            hmsTable.getParameters().put("external.table.purge", "TRUE");
        }
        PARAMETERS_TO_REMOVE.forEach(hmsTable.getParameters()::remove);
    }

    public void rollbackCreateTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
    }

    public void commitCreateTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        if (this.icebergTable == null) {
            if (Catalogs.hiveCatalog(this.conf)) {
                this.catalogProperties.put("engine.hive.enabled", (Object)true);
            }
            Catalogs.createTable(this.conf, this.catalogProperties);
        }
    }

    public void preDropTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        this.catalogProperties = this.getCatalogProperties(hmsTable);
        boolean bl = this.deleteIcebergTable = hmsTable.getParameters() != null && "TRUE".equalsIgnoreCase((String)hmsTable.getParameters().get("external.table.purge"));
        if (this.deleteIcebergTable && Catalogs.hiveCatalog(this.conf)) {
            String metadataLocation = (String)hmsTable.getParameters().get("metadata_location");
            this.deleteIo = Catalogs.loadTable(this.conf, this.catalogProperties).io();
            this.deleteMetadata = TableMetadataParser.read(this.deleteIo, metadataLocation);
        }
    }

    public void rollbackDropTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
    }

    public void commitDropTable(org.apache.hadoop.hive.metastore.api.Table hmsTable, boolean deleteData) {
        if (deleteData && this.deleteIcebergTable) {
            if (!Catalogs.hiveCatalog(this.conf)) {
                LOG.info("Dropping with purge all the data for table {}.{}", (Object)hmsTable.getDbName(), (Object)hmsTable.getTableName());
                Catalogs.dropTable(this.conf, this.catalogProperties);
            } else {
                CatalogUtil.dropTableData(this.deleteIo, this.deleteMetadata);
            }
        }
    }

    private Properties getCatalogProperties(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)hmsTable.getParameters());
        if (properties.get("location") == null && hmsTable.getSd() != null && hmsTable.getSd().getLocation() != null) {
            properties.put("location", hmsTable.getSd().getLocation());
        }
        if (properties.get("name") == null) {
            properties.put("name", TableIdentifier.of(hmsTable.getDbName(), hmsTable.getTableName()).toString());
        }
        PROPERTIES_TO_REMOVE.forEach(properties::remove);
        return properties;
    }
}

