/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentImpl;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.iceberg.common.DynFields;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.util.DateTimeUtil;

public class HiveIcebergFilterFactory {
    private static final DynFields.UnboundField<?> LITERAL_FIELD = DynFields.builder().hiddenImpl(SearchArgumentImpl.PredicateLeafImpl.class, "literal").build();

    private HiveIcebergFilterFactory() {
    }

    public static Expression generateFilterExpression(SearchArgument sarg) {
        return HiveIcebergFilterFactory.translate(sarg.getExpression(), sarg.getLeaves());
    }

    private static Expression translate(ExpressionTree tree, List<PredicateLeaf> leaves) {
        List childNodes = tree.getChildren();
        switch (tree.getOperator()) {
            case OR: {
                Expression orResult = Expressions.alwaysFalse();
                for (ExpressionTree child : childNodes) {
                    orResult = Expressions.or(orResult, HiveIcebergFilterFactory.translate(child, leaves));
                }
                return orResult;
            }
            case AND: {
                Expression result = Expressions.alwaysTrue();
                for (ExpressionTree child : childNodes) {
                    result = Expressions.and(result, HiveIcebergFilterFactory.translate(child, leaves));
                }
                return result;
            }
            case NOT: {
                return Expressions.not(HiveIcebergFilterFactory.translate((ExpressionTree)childNodes.get(0), leaves));
            }
            case LEAF: {
                return HiveIcebergFilterFactory.translateLeaf(leaves.get(tree.getLeaf()));
            }
            case CONSTANT: {
                throw new UnsupportedOperationException("CONSTANT operator is not supported");
            }
        }
        throw new UnsupportedOperationException("Unknown operator: " + tree.getOperator());
    }

    private static Expression translateLeaf(PredicateLeaf leaf) {
        String column = leaf.getColumnName();
        switch (leaf.getOperator()) {
            case EQUALS: {
                return Expressions.equal(column, HiveIcebergFilterFactory.leafToLiteral(leaf));
            }
            case LESS_THAN: {
                return Expressions.lessThan(column, HiveIcebergFilterFactory.leafToLiteral(leaf));
            }
            case LESS_THAN_EQUALS: {
                return Expressions.lessThanOrEqual(column, HiveIcebergFilterFactory.leafToLiteral(leaf));
            }
            case IN: {
                return Expressions.in(column, HiveIcebergFilterFactory.leafToLiteralList(leaf));
            }
            case BETWEEN: {
                List<Object> icebergLiterals = HiveIcebergFilterFactory.leafToLiteralList(leaf);
                return Expressions.and(Expressions.greaterThanOrEqual(column, icebergLiterals.get(0)), Expressions.lessThanOrEqual(column, icebergLiterals.get(1)));
            }
            case IS_NULL: {
                return Expressions.isNull(column);
            }
        }
        throw new UnsupportedOperationException("Unknown operator: " + leaf.getOperator());
    }

    private static Object leafToLiteral(PredicateLeaf leaf) {
        switch (leaf.getType()) {
            case LONG: 
            case BOOLEAN: 
            case STRING: 
            case FLOAT: {
                return leaf.getLiteral();
            }
            case DATE: {
                if (leaf.getLiteral() instanceof Date) {
                    return HiveIcebergFilterFactory.daysFromDate((Date)leaf.getLiteral());
                }
                return HiveIcebergFilterFactory.daysFromTimestamp((Timestamp)leaf.getLiteral());
            }
            case TIMESTAMP: {
                return HiveIcebergFilterFactory.microsFromTimestamp((Timestamp)LITERAL_FIELD.get(leaf));
            }
            case DECIMAL: {
                return HiveIcebergFilterFactory.hiveDecimalToBigDecimal((HiveDecimalWritable)leaf.getLiteral());
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + leaf.getType());
    }

    private static List<Object> leafToLiteralList(PredicateLeaf leaf) {
        switch (leaf.getType()) {
            case LONG: 
            case BOOLEAN: 
            case STRING: 
            case FLOAT: {
                return leaf.getLiteralList();
            }
            case DATE: {
                return leaf.getLiteralList().stream().map(value -> HiveIcebergFilterFactory.daysFromDate((Date)value)).collect(Collectors.toList());
            }
            case DECIMAL: {
                return leaf.getLiteralList().stream().map(value -> HiveIcebergFilterFactory.hiveDecimalToBigDecimal((HiveDecimalWritable)value)).collect(Collectors.toList());
            }
            case TIMESTAMP: {
                return leaf.getLiteralList().stream().map(value -> HiveIcebergFilterFactory.microsFromTimestamp((Timestamp)value)).collect(Collectors.toList());
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + leaf.getType());
    }

    private static BigDecimal hiveDecimalToBigDecimal(HiveDecimalWritable hiveDecimalWritable) {
        return hiveDecimalWritable.getHiveDecimal().bigDecimalValue().setScale(hiveDecimalWritable.scale());
    }

    private static int daysFromDate(Date date) {
        return DateTimeUtil.daysFromInstant(Instant.ofEpochMilli(date.getTime()));
    }

    private static int daysFromTimestamp(Timestamp timestamp) {
        return DateTimeUtil.daysFromInstant(timestamp.toInstant());
    }

    private static long microsFromTimestamp(Timestamp timestamp) {
        return DateTimeUtil.microsFromInstant(timestamp.toInstant());
    }
}

