/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr;

import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.mr.CatalogLoader;
import org.apache.iceberg.mr.SerializationUtil;

public class InputFormatConfig {
    public static final String REUSE_CONTAINERS = "iceberg.mr.reuse.containers";
    public static final String CASE_SENSITIVE = "iceberg.mr.case.sensitive";
    public static final String SKIP_RESIDUAL_FILTERING = "skip.residual.filtering";
    public static final String AS_OF_TIMESTAMP = "iceberg.mr.as.of.time";
    public static final String FILTER_EXPRESSION = "iceberg.mr.filter.expression";
    public static final String IN_MEMORY_DATA_MODEL = "iceberg.mr.in.memory.data.model";
    public static final String READ_SCHEMA = "iceberg.mr.read.schema";
    public static final String SNAPSHOT_ID = "iceberg.mr.snapshot.id";
    public static final String SPLIT_SIZE = "iceberg.mr.split.size";
    public static final String TABLE_IDENTIFIER = "iceberg.mr.table.identifier";
    public static final String TABLE_LOCATION = "iceberg.mr.table.location";
    public static final String TABLE_SCHEMA = "iceberg.mr.table.schema";
    public static final String PARTITION_SPEC = "iceberg.mr.table.partition.spec";
    public static final String LOCALITY = "iceberg.mr.locality";
    public static final String CATALOG = "iceberg.mr.catalog";
    public static final String HADOOP_CATALOG_WAREHOUSE_LOCATION = "iceberg.mr.catalog.hadoop.warehouse.location";
    public static final String CATALOG_LOADER_CLASS = "iceberg.mr.catalog.loader.class";
    public static final String EXTERNAL_TABLE_PURGE = "external.table.purge";
    public static final String CATALOG_NAME = "iceberg.catalog";
    public static final String HADOOP_CATALOG = "hadoop.catalog";
    public static final String HADOOP_TABLES = "hadoop.tables";
    public static final String HIVE_CATALOG = "hive.catalog";
    public static final String ICEBERG_SNAPSHOTS_TABLE_SUFFIX = ".snapshots";
    public static final String SNAPSHOT_TABLE = "iceberg.snapshots.table";
    public static final String SNAPSHOT_TABLE_SUFFIX = "__snapshots";

    private InputFormatConfig() {
    }

    public static class ConfigBuilder {
        private final Configuration conf;

        public ConfigBuilder(Configuration conf) {
            this.conf = conf;
            conf.setBoolean(InputFormatConfig.SKIP_RESIDUAL_FILTERING, false);
            conf.setBoolean(InputFormatConfig.CASE_SENSITIVE, true);
            conf.setBoolean(InputFormatConfig.REUSE_CONTAINERS, false);
            conf.setBoolean(InputFormatConfig.LOCALITY, false);
        }

        public Configuration conf() {
            return this.conf;
        }

        public ConfigBuilder filter(Expression expression) {
            this.conf.set(InputFormatConfig.FILTER_EXPRESSION, SerializationUtil.serializeToBase64(expression));
            return this;
        }

        public ConfigBuilder project(Schema schema) {
            this.conf.set(InputFormatConfig.READ_SCHEMA, SchemaParser.toJson(schema));
            return this;
        }

        public ConfigBuilder schema(Schema schema) {
            this.conf.set(InputFormatConfig.TABLE_SCHEMA, SchemaParser.toJson(schema));
            return this;
        }

        public ConfigBuilder readFrom(TableIdentifier identifier) {
            this.conf.set(InputFormatConfig.TABLE_IDENTIFIER, identifier.toString());
            return this;
        }

        public ConfigBuilder readFrom(String location) {
            this.conf.set(InputFormatConfig.TABLE_LOCATION, location);
            return this;
        }

        public ConfigBuilder reuseContainers(boolean reuse) {
            this.conf.setBoolean(InputFormatConfig.REUSE_CONTAINERS, reuse);
            return this;
        }

        public ConfigBuilder caseSensitive(boolean caseSensitive) {
            this.conf.setBoolean(InputFormatConfig.CASE_SENSITIVE, caseSensitive);
            return this;
        }

        public ConfigBuilder snapshotId(long snapshotId) {
            this.conf.setLong(InputFormatConfig.SNAPSHOT_ID, snapshotId);
            return this;
        }

        public ConfigBuilder asOfTime(long asOfTime) {
            this.conf.setLong(InputFormatConfig.AS_OF_TIMESTAMP, asOfTime);
            return this;
        }

        public ConfigBuilder splitSize(long splitSize) {
            this.conf.setLong(InputFormatConfig.SPLIT_SIZE, splitSize);
            return this;
        }

        public ConfigBuilder preferLocality() {
            this.conf.setBoolean(InputFormatConfig.LOCALITY, true);
            return this;
        }

        public ConfigBuilder catalogLoader(Class<? extends CatalogLoader> catalogLoader) {
            this.conf.setClass(InputFormatConfig.CATALOG_LOADER_CLASS, catalogLoader, CatalogLoader.class);
            return this;
        }

        public ConfigBuilder useHiveRows() {
            this.conf.set(InputFormatConfig.IN_MEMORY_DATA_MODEL, InMemoryDataModel.HIVE.name());
            return this;
        }

        public ConfigBuilder usePigTuples() {
            this.conf.set(InputFormatConfig.IN_MEMORY_DATA_MODEL, InMemoryDataModel.PIG.name());
            return this;
        }

        public ConfigBuilder skipResidualFiltering() {
            this.conf.setBoolean(InputFormatConfig.SKIP_RESIDUAL_FILTERING, true);
            return this;
        }
    }

    public static enum InMemoryDataModel {
        PIG,
        HIVE,
        GENERIC;

    }
}

