/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.Tasks;

public abstract class BaseTaskWriter<T>
implements TaskWriter<T> {
    private final List<DataFile> completedFiles = Lists.newArrayList();
    private final PartitionSpec spec;
    private final FileFormat format;
    private final FileAppenderFactory<T> appenderFactory;
    private final OutputFileFactory fileFactory;
    private final FileIO io;
    private final long targetFileSize;

    protected BaseTaskWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<T> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize) {
        this.spec = spec;
        this.format = format;
        this.appenderFactory = appenderFactory;
        this.fileFactory = fileFactory;
        this.io = io;
        this.targetFileSize = targetFileSize;
    }

    @Override
    public void abort() throws IOException {
        this.close();
        Tasks.foreach(this.completedFiles).throwFailureWhenFinished().noRetry().run(file -> this.io.deleteFile(file.path().toString()));
    }

    @Override
    public DataFile[] complete() throws IOException {
        this.close();
        return this.completedFiles.toArray(new DataFile[0]);
    }

    protected class RollingFileWriter
    implements Closeable {
        private static final int ROWS_DIVISOR = 1000;
        private final PartitionKey partitionKey;
        private EncryptedOutputFile currentFile = null;
        private FileAppender<T> currentAppender = null;
        private long currentRows = 0L;

        public RollingFileWriter(PartitionKey partitionKey) {
            this.partitionKey = partitionKey;
            this.openCurrent();
        }

        public void add(T record) throws IOException {
            this.currentAppender.add(record);
            ++this.currentRows;
            if (this.shouldRollToNewFile()) {
                this.closeCurrent();
                this.openCurrent();
            }
        }

        private void openCurrent() {
            this.currentFile = this.partitionKey == null ? BaseTaskWriter.this.fileFactory.newOutputFile() : BaseTaskWriter.this.fileFactory.newOutputFile(this.partitionKey);
            this.currentAppender = BaseTaskWriter.this.appenderFactory.newAppender(this.currentFile.encryptingOutputFile(), BaseTaskWriter.this.format);
            this.currentRows = 0L;
        }

        private boolean shouldRollToNewFile() {
            return !BaseTaskWriter.this.format.equals((Object)FileFormat.ORC) && this.currentRows % 1000L == 0L && this.currentAppender.length() >= BaseTaskWriter.this.targetFileSize;
        }

        private void closeCurrent() throws IOException {
            if (this.currentAppender != null) {
                this.currentAppender.close();
                Metrics metrics = this.currentAppender.metrics();
                long fileSizeInBytes = this.currentAppender.length();
                List<Long> splitOffsets = this.currentAppender.splitOffsets();
                this.currentAppender = null;
                if (metrics.recordCount() == 0L) {
                    BaseTaskWriter.this.io.deleteFile(this.currentFile.encryptingOutputFile());
                } else {
                    DataFile dataFile = DataFiles.builder(BaseTaskWriter.this.spec).withEncryptionKeyMetadata(this.currentFile.keyMetadata()).withPath(this.currentFile.encryptingOutputFile().location()).withFileSizeInBytes(fileSizeInBytes).withPartition(BaseTaskWriter.this.spec.fields().size() == 0 ? null : this.partitionKey).withMetrics(metrics).withSplitOffsets(splitOffsets).build();
                    BaseTaskWriter.this.completedFiles.add(dataFile);
                }
                this.currentFile = null;
                this.currentRows = 0L;
            }
        }

        @Override
        public void close() throws IOException {
            this.closeCurrent();
        }
    }
}

