/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.iceberg.io.DelegatingInputStream;
import org.apache.iceberg.io.DelegatingOutputStream;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HadoopStreams {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopStreams.class);

    private HadoopStreams() {
    }

    static SeekableInputStream wrap(FSDataInputStream stream) {
        return new HadoopSeekableInputStream(stream);
    }

    static PositionOutputStream wrap(FSDataOutputStream stream) {
        return new HadoopPositionOutputStream(stream);
    }

    private static class HadoopPositionOutputStream
    extends PositionOutputStream
    implements DelegatingOutputStream {
        private final FSDataOutputStream stream;
        private final StackTraceElement[] createStack;
        private boolean closed;

        HadoopPositionOutputStream(FSDataOutputStream stream) {
            this.stream = stream;
            this.createStack = Thread.currentThread().getStackTrace();
            this.closed = false;
        }

        @Override
        public OutputStream getDelegate() {
            return this.stream;
        }

        @Override
        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        @Override
        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.stream.flush();
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
            this.closed = true;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.closed) {
                this.close();
                String trace = Joiner.on("\n\t").join(Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
                LOG.warn("Unclosed output stream created by:\n\t{}", (Object)trace);
            }
        }
    }

    private static class HadoopSeekableInputStream
    extends SeekableInputStream
    implements DelegatingInputStream {
        private final FSDataInputStream stream;
        private final StackTraceElement[] createStack;
        private boolean closed;

        HadoopSeekableInputStream(FSDataInputStream stream) {
            this.stream = stream;
            this.createStack = Thread.currentThread().getStackTrace();
            this.closed = false;
        }

        @Override
        public InputStream getDelegate() {
            return this.stream;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
            this.closed = true;
        }

        @Override
        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        @Override
        public void seek(long newPos) throws IOException {
            this.stream.seek(newPos);
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        public int read(ByteBuffer buf) throws IOException {
            return this.stream.read(buf);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.closed) {
                this.close();
                String trace = Joiner.on("\n\t").join(Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
                LOG.warn("Unclosed input stream created by:\n\t{}", (Object)trace);
            }
        }
    }
}

