/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.DelegatingInputStream;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.shaded.org.apache.avro.InvalidAvroMagicException;
import org.apache.iceberg.shaded.org.apache.avro.file.SeekableInput;
import org.apache.iceberg.shaded.org.apache.avro.io.BinaryDecoder;
import org.apache.iceberg.shaded.org.apache.avro.io.DecoderFactory;

class AvroIO {
    private static final byte[] AVRO_MAGIC = new byte[]{79, 98, 106, 1};
    private static final ValueReader<byte[]> MAGIC_READER = ValueReaders.fixed(AVRO_MAGIC.length);
    private static final ValueReader<Map<String, String>> META_READER = ValueReaders.map(ValueReaders.strings(), ValueReaders.strings());
    private static final ValueReader<byte[]> SYNC_READER = ValueReaders.fixed(16);
    private static final Class<?> fsDataInputStreamClass = DynClasses.builder().impl("org.apache.hadoop.fs.FSDataInputStream").orNull().build();
    private static final boolean relocated = "org.apache.iceberg.shaded.org.apache.avro.file.SeekableInput".equals(SeekableInput.class.getName());
    private static final DynConstructors.Ctor<SeekableInput> avroFsInputCtor = !relocated && fsDataInputStreamClass != null ? DynConstructors.builder(SeekableInput.class).impl("org.apache.hadoop.fs.AvroFSInput", fsDataInputStreamClass, Long.TYPE).build() : null;

    private AvroIO() {
    }

    static SeekableInput stream(SeekableInputStream stream, long length) {
        if (stream instanceof DelegatingInputStream) {
            InputStream wrapped = ((DelegatingInputStream)((Object)stream)).getDelegate();
            if (avroFsInputCtor != null && fsDataInputStreamClass != null && fsDataInputStreamClass.isInstance(wrapped)) {
                return avroFsInputCtor.newInstance(wrapped, length);
            }
        }
        return new AvroInputStreamAdapter(stream, length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long findStartingRowPos(Supplier<SeekableInputStream> open, long start) {
        long totalRows = 0L;
        try (SeekableInputStream in = open.get();){
            BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder(in, null);
            byte[] magic = MAGIC_READER.read(decoder, null);
            if (!Arrays.equals(AVRO_MAGIC, magic)) {
                throw new InvalidAvroMagicException("Not an Avro file");
            }
            META_READER.read(decoder, null);
            byte[] fileSync = SYNC_READER.read(decoder, null);
            byte[] blockSync = new byte[16];
            long nextSyncPos = in.getPos();
            while (nextSyncPos < start) {
                if (nextSyncPos != in.getPos()) {
                    in.seek(nextSyncPos);
                    SYNC_READER.read(decoder, blockSync);
                    if (!Arrays.equals(fileSync, blockSync)) {
                        throw new RuntimeIOException("Invalid sync at %s", nextSyncPos);
                    }
                }
                long rowCount = decoder.readLong();
                long compressedBlockSize = decoder.readLong();
                totalRows += rowCount;
                nextSyncPos = in.getPos() + compressedBlockSize;
            }
            long l = totalRows;
            return l;
        }
        catch (EOFException e) {
            return totalRows;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to read stream while finding starting row position", new Object[0]);
        }
    }

    private static class AvroInputStreamAdapter
    extends SeekableInputStream
    implements SeekableInput {
        private final SeekableInputStream stream;
        private final long length;

        AvroInputStreamAdapter(SeekableInputStream stream, long length) {
            this.stream = stream;
            this.length = length;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        @Override
        public void seek(long newPos) throws IOException {
            this.stream.seek(newPos);
        }

        @Override
        public long tell() throws IOException {
            return this.getPos();
        }

        @Override
        public long length() throws IOException {
            return this.length;
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.stream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.stream.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.stream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }
    }
}

