/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.actions.Action;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

abstract class BaseAction<R>
implements Action<R> {
    BaseAction() {
    }

    protected abstract Table table();

    protected String metadataTableName(MetadataTableType type) {
        return this.metadataTableName(this.table().name(), type);
    }

    protected String metadataTableName(String tableName, MetadataTableType type) {
        if (tableName.contains("/")) {
            return tableName + "#" + (Object)((Object)type);
        }
        if (tableName.startsWith("hadoop.")) {
            return this.table().location() + "#" + (Object)((Object)type);
        }
        if (tableName.startsWith("hive.")) {
            return tableName.replaceFirst("hive\\.", "") + "." + (Object)((Object)type);
        }
        return tableName + "." + (Object)((Object)type);
    }

    protected List<String> getManifestListPaths(Iterable<Snapshot> snapshots) {
        ArrayList<String> manifestLists = Lists.newArrayList();
        for (Snapshot snapshot : snapshots) {
            String manifestListLocation = snapshot.manifestListLocation();
            if (manifestListLocation == null) continue;
            manifestLists.add(manifestListLocation);
        }
        return manifestLists;
    }

    protected List<String> getOtherMetadataFilePaths(TableOperations ops) {
        ArrayList<String> otherMetadataFiles = Lists.newArrayList();
        otherMetadataFiles.add(ops.metadataFileLocation("version-hint.text"));
        TableMetadata metadata = ops.current();
        otherMetadataFiles.add(metadata.metadataFileLocation());
        for (TableMetadata.MetadataLogEntry previousMetadataFile : metadata.previousFiles()) {
            otherMetadataFiles.add(previousMetadataFile.file());
        }
        return otherMetadataFiles;
    }
}

