/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;

public class StaticTableOperations
implements TableOperations {
    private final TableMetadata staticMetadata;
    private final FileIO io;

    public StaticTableOperations(String metadataFileLocation, FileIO io) {
        this.io = io;
        this.staticMetadata = TableMetadataParser.read(io, metadataFileLocation);
    }

    @Override
    public TableMetadata current() {
        return this.staticMetadata;
    }

    @Override
    public TableMetadata refresh() {
        return this.staticMetadata;
    }

    @Override
    public void commit(TableMetadata base, TableMetadata metadata) {
        throw new UnsupportedOperationException("Cannot modify a static table");
    }

    @Override
    public FileIO io() {
        return this.io;
    }

    @Override
    public String metadataFileLocation(String fileName) {
        throw new UnsupportedOperationException("Cannot modify a static table");
    }

    @Override
    public LocationProvider locationProvider() {
        throw new UnsupportedOperationException("Cannot modify a static table");
    }
}

