/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class MetricsModes {
    private static final Pattern TRUNCATE = Pattern.compile("truncate\\((\\d+)\\)");

    private MetricsModes() {
    }

    public static MetricsMode fromString(String mode) {
        if ("none".equalsIgnoreCase(mode)) {
            return None.get();
        }
        if ("counts".equalsIgnoreCase(mode)) {
            return Counts.get();
        }
        if ("full".equalsIgnoreCase(mode)) {
            return Full.get();
        }
        Matcher truncateMatcher = TRUNCATE.matcher(mode.toLowerCase(Locale.ENGLISH));
        if (truncateMatcher.matches()) {
            int length = Integer.parseInt(truncateMatcher.group(1));
            return Truncate.withLength(length);
        }
        throw new IllegalArgumentException("Invalid metrics mode: " + mode);
    }

    private static class MetricsModeProxy
    implements Serializable {
        private String modeAsString;

        MetricsModeProxy(String modeAsString) {
            this.modeAsString = modeAsString;
        }

        Object readResolve() throws ObjectStreamException {
            return MetricsModes.fromString(this.modeAsString);
        }
    }

    private static abstract class ProxySerializableMetricsMode
    implements MetricsMode {
        private ProxySerializableMetricsMode() {
        }

        Object writeReplace() throws ObjectStreamException {
            return new MetricsModeProxy(this.toString());
        }
    }

    public static class Full
    extends ProxySerializableMetricsMode {
        private static final Full INSTANCE = new Full();

        public static Full get() {
            return INSTANCE;
        }

        public String toString() {
            return "full";
        }
    }

    public static class Truncate
    extends ProxySerializableMetricsMode {
        private final int length;

        private Truncate(int length) {
            this.length = length;
        }

        public static Truncate withLength(int length) {
            Preconditions.checkArgument(length > 0, "Truncate length should be positive");
            return new Truncate(length);
        }

        public int length() {
            return this.length;
        }

        public String toString() {
            return String.format("truncate(%d)", this.length);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Truncate)) {
                return false;
            }
            Truncate truncate = (Truncate)other;
            return this.length == truncate.length;
        }

        public int hashCode() {
            return Objects.hash(this.length);
        }
    }

    public static class Counts
    extends ProxySerializableMetricsMode {
        private static final Counts INSTANCE = new Counts();

        public static Counts get() {
            return INSTANCE;
        }

        public String toString() {
            return "counts";
        }
    }

    public static class None
    extends ProxySerializableMetricsMode {
        private static final None INSTANCE = new None();

        public static None get() {
            return INSTANCE;
        }

        public String toString() {
            return "none";
        }
    }

    public static interface MetricsMode
    extends Serializable {
    }
}

